/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.StrUtil;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.service.service.JdCloudService;
import com.zbkj.service.service.SystemConfigService;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JdCloudServiceImpl
implements JdCloudService {
    private static final Logger log = LoggerFactory.getLogger(JdCloudServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public void uploadFile(String fileName, String localFilePath, String bucket) {
        File file = new File(localFilePath);
        if (!file.exists()) {
            log.error("\u4eac\u4e1c\u4e91\u5b58\u50a8\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0d\u5b58\u5728\uff0cfileName = {}\uff0c localFilePath = {}", (Object)fileName, (Object)localFilePath);
            return;
        }
        AmazonS3 s3 = this.getAmazonS3Client();
        try {
            if (!s3.doesBucketExistV2(bucket)) {
                s3.createBucket(bucket);
            }
            PutObjectResult putObjectResult = s3.putObject(bucket, fileName, file);
            log.info("\u4eac\u4e1c\u4e91\u5b58\u50a8\u4e0a\u4f20\u6587\u4ef6\u7ed3\u675f\uff1a{}", (Object)putObjectResult.getETag());
        }
        catch (Exception e) {
            log.error("upload JD OSS file error : ", (Throwable)e);
            throw new CrmebException(e.getMessage());
        }
        finally {
            s3.shutdown();
        }
    }

    @Override
    public void createBucket(String bucketName) {
        if (StrUtil.isBlank((CharSequence)bucketName)) {
            return;
        }
        AmazonS3 s3 = this.getAmazonS3Client();
        try {
            s3.createBucket(bucketName);
            log.info("create JD OSS bucket {} ", (Object)bucketName);
        }
        catch (AmazonServiceException e) {
            log.error("create JD OSS bucket err : ", (Throwable)e);
            throw new CrmebException("\u4eac\u4e1c\u4e91\u5b58\u50a8\u521b\u5efa\u5b58\u50a8\u7a7a\u95f4\u5931\u8d25:" + e.getMessage());
        }
        finally {
            s3.shutdown();
        }
    }

    @Override
    public String getUrl(String bucket, String fileName) {
        AmazonS3 s3 = this.getAmazonS3Client();
        String urlPath = "";
        try {
            URL url = s3.getUrl(bucket, "w5.webp");
            urlPath = url.toString();
        }
        catch (Exception e) {
            log.error("get JD OSS file url err : ", (Throwable)e);
            throw new CrmebException("\u4eac\u4e1c\u4e91\u83b7\u53d6\u6587\u4ef6\u5730\u5740\u5931\u8d25:" + e.getMessage());
        }
        finally {
            s3.shutdown();
        }
        return urlPath;
    }

    private AmazonS3 getAmazonS3Client() {
        String endpoint = this.systemConfigService.getValueByKeyException("jdEndpoint");
        String accessKey = this.systemConfigService.getValueByKeyException("jdAccessKey");
        String secretKey = this.systemConfigService.getValueByKeyException("jdSecretKey");
        String signingRegion = this.systemConfigService.getValueByKeyException("jdSigningRegion");
        ClientConfiguration config = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(endpoint, signingRegion);
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, secretKey);
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfig)).withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).build();
        return s3;
    }
}

