/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.user.User;
import com.zbkj.common.request.OrderSearchRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.ExportUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.utils.UploadUtil;
import com.zbkj.common.vo.OrderExcelVo;
import com.zbkj.service.service.ExportService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.UserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportServiceImpl
implements ExportService {
    @Autowired
    private OrderService orderService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private CrmebConfig crmebConfig;

    @Override
    public String exportOrder(OrderSearchRequest request) {
        List<Order> orderList;
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (systemAdmin.getMerId() > 0) {
            request.setMerId(systemAdmin.getMerId());
        }
        if (CollUtil.isEmpty(orderList = this.orderService.findExportList(request))) {
            throw new CrmebException("\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\uff01");
        }
        List<Integer> merIdList = orderList.stream().filter(e -> e.getMerId() > 0).map(Order::getMerId).distinct().collect(Collectors.toList());
        List<Integer> userIdList = orderList.stream().map(Order::getUid).distinct().collect(Collectors.toList());
        List<String> orderNoList = orderList.stream().map(Order::getOrderNo).distinct().collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = this.merchantService.getMapByIdList(merIdList);
        Map<Integer, User> userMap = this.userService.getUidMapList(userIdList);
        Map<String, List<OrderDetail>> orderDetailMap = this.orderDetailService.getMapByOrderNoList(orderNoList);
        ArrayList voList = CollUtil.newArrayList((Object[])new OrderExcelVo[0]);
        for (Order order : orderList) {
            OrderExcelVo vo = new OrderExcelVo();
            vo.setType(this.getOrderType(order.getType()));
            vo.setOrderNo(order.getOrderNo());
            vo.setMerName(order.getMerId() > 0 ? merchantMap.get(order.getMerId()).getName() : "");
            User user = userMap.get(order.getUid());
            vo.setUserNickname(user != null ? user.getNickname() + "|" + order.getUid() : order.getUid().toString());
            vo.setPayPrice(order.getPayPrice().toString());
            vo.setPaidStr(order.getPaid() != false ? "\u5df2\u652f\u4ed8" : "\u672a\u652f\u4ed8");
            vo.setPayType(this.getOrderPayType(order.getPayType()));
            vo.setPayChannel(this.getOrderPayChannel(order.getPayChannel()));
            vo.setStatus(this.getOrderStatus(order.getStatus()));
            vo.setRefundStatus(this.getOrderRefundStatus(order.getRefundStatus()));
            vo.setCreateTime(CrmebDateUtil.dateToStr((Date)order.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            vo.setProductInfo(this.getOrderProductInfo(orderDetailMap.get(order.getOrderNo())));
            voList.add(vo);
        }
        UploadUtil.setHzwServerPath((String)(this.crmebConfig.getImagePath() + "/").replace(" ", "").replace("//", "/"));
        String fileName = "\u8ba2\u5355\u5bfc\u51fa_".concat(CrmebDateUtil.nowDateTime((String)"yyyyMMddHHmmss")).concat(CrmebUtil.randomCount((Integer)111111111, (Integer)999999999).toString()).concat(".xlsx");
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        aliasMap.put("type", "\u8ba2\u5355\u7c7b\u578b");
        aliasMap.put("orderNo", "\u8ba2\u5355\u53f7");
        aliasMap.put("merName", "\u5546\u6237\u540d\u79f0");
        aliasMap.put("userNickname", "\u7528\u6237\u6635\u79f0");
        aliasMap.put("payPrice", "\u5b9e\u9645\u652f\u4ed8\u91d1\u989d");
        aliasMap.put("paidStr", "\u652f\u4ed8\u72b6\u6001");
        aliasMap.put("payType", "\u652f\u4ed8\u65b9\u5f0f");
        aliasMap.put("payChannel", "\u652f\u4ed8\u6e20\u9053");
        aliasMap.put("status", "\u8ba2\u5355\u72b6\u6001");
        aliasMap.put("refundStatus", "\u9000\u6b3e\u72b6\u6001");
        aliasMap.put("createTime", "\u521b\u5efa\u65f6\u95f4");
        aliasMap.put("productInfo", "\u5546\u54c1\u4fe1\u606f");
        return ExportUtil.exportExcel((String)fileName, (String)"\u8ba2\u5355\u5bfc\u51fa", (List)voList, aliasMap);
    }

    private String getOrderProductInfo(List<OrderDetail> orderDetails) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < orderDetails.size(); ++i) {
            OrderDetail orderDetail = orderDetails.get(i);
            stringBuilder.append(StrUtil.format((CharSequence)"{}  {} * {}", (Object[])new Object[]{orderDetail.getProductName(), orderDetail.getPayPrice(), orderDetail.getPayNum()}));
            if (i + 1 >= orderDetails.size()) continue;
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    private String getOrderType(Integer type) {
        String typeStr = "";
        switch (type) {
            case 0: {
                typeStr = "\u666e\u901a";
                break;
            }
            case 1: {
                typeStr = "\u89c6\u9891\u53f7";
                break;
            }
            case 2: {
                typeStr = "\u79d2\u6740";
            }
        }
        return typeStr;
    }

    private String getOrderRefundStatus(Integer refundStatus) {
        String refundStatusStr = "";
        switch (refundStatus) {
            case 0: {
                refundStatusStr = "\u672a\u9000\u6b3e";
                break;
            }
            case 1: {
                refundStatusStr = "\u7533\u8bf7\u4e2d";
                break;
            }
            case 2: {
                refundStatusStr = "\u90e8\u5206\u9000\u6b3e";
                break;
            }
            case 3: {
                refundStatusStr = "\u5df2\u9000\u6b3e";
            }
        }
        return refundStatusStr;
    }

    private String getOrderStatus(Integer status) {
        String statusStr = "";
        switch (status) {
            case 0: {
                statusStr = "\u5f85\u652f\u4ed8";
                break;
            }
            case 1: {
                statusStr = "\u5f85\u53d1\u8d27";
                break;
            }
            case 2: {
                statusStr = "\u90e8\u5206\u53d1\u8d27";
                break;
            }
            case 3: {
                statusStr = "\u5f85\u6838\u9500";
                break;
            }
            case 4: {
                statusStr = "\u5f85\u6536\u8d27";
                break;
            }
            case 5: {
                statusStr = "\u5df2\u6536\u8d27";
                break;
            }
            case 6: {
                statusStr = "\u5df2\u5b8c\u6210";
                break;
            }
            case 9: {
                statusStr = "\u5df2\u53d6\u6d88";
            }
        }
        return statusStr;
    }

    private String getOrderPayChannel(String payChannel) {
        String payChannelStr = "";
        switch (payChannel) {
            case "public": {
                payChannelStr = "\u516c\u4f17\u53f7";
                break;
            }
            case "mini": {
                payChannelStr = "\u5c0f\u7a0b\u5e8f";
                break;
            }
            case "h5": {
                payChannelStr = "\u5fae\u4fe1\u7f51\u9875\u652f\u4ed8";
                break;
            }
            case "yue": {
                payChannelStr = "\u4f59\u989d";
                break;
            }
            case "wechatIos": {
                payChannelStr = "\u5fae\u4fe1Ios";
                break;
            }
            case "wechatAndroid": {
                payChannelStr = "\u5fae\u4fe1Android";
                break;
            }
            case "alipay": {
                payChannelStr = "\u652f\u4ed8\u5b9d";
                break;
            }
            case "alipayApp": {
                payChannelStr = "\u652f\u4ed8\u5b9dApp";
            }
        }
        return payChannelStr;
    }

    private String getOrderPayType(String payType) {
        String payTypeStr = "";
        switch (payType) {
            case "weixin": {
                payTypeStr = "\u5fae\u4fe1\u652f\u4ed8";
                break;
            }
            case "alipay": {
                payTypeStr = "\u652f\u4ed8\u5b9d\u652f\u4ed8";
                break;
            }
            case "yue": {
                payTypeStr = "\u4f59\u989d\u652f\u4ed8";
            }
        }
        return payTypeStr;
    }
}

