/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.service.dao.MerchantOrderDao;
import com.zbkj.service.service.MerchantOrderService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MerchantOrderServiceImpl
extends ServiceImpl<MerchantOrderDao, MerchantOrder>
implements MerchantOrderService {
    @Resource
    private MerchantOrderDao dao;

    @Override
    public List<MerchantOrder> getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantOrder::getOrderNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public MerchantOrder getOneByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantOrder::getOrderNo, (Object)orderNo);
        lqw.last(" limit 1");
        return (MerchantOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean virtual(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(MerchantOrder::getDeliveryType, (Object)"fictitious");
        wrapper.eq(MerchantOrder::getOrderNo, (Object)orderNo);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public MerchantOrder getOneByVerifyCode(String verifyCode) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantOrder::getVerifyCode, (Object)verifyCode);
        lqw.orderByDesc(MerchantOrder::getId);
        lqw.last("limit 1");
        return (MerchantOrder)this.dao.selectOne((Wrapper)lqw);
    }
}

