/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWalletAccount;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.MerchantprodMerchantArrangementInfoNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.MerchantprodMerchantArrangementInfoNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="merchantprodMerchantArrangementInfoNotifyService")
public class MerchantprodMerchantArrangementInfoNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(MerchantprodMerchantArrangementInfoNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > \u6388\u6743/\u89e3\u7ea6\u6210\u529f\u901a\u77e5\u63a5\u53e3\uff1aant.mybank.merchantprod.merchant.arrangement.info.notify");
        logger.info("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        MerchantprodMerchantArrangementInfoNotifyRequest arrangeMentInfoNotify = XmlConverter.getInstance().toResponse(context, MerchantprodMerchantArrangementInfoNotifyRequest.class);
        RequestHead head = arrangeMentInfoNotify.getMerchantprodMerchantArrangementInfoNotify().getRequestHead();
        boolean flag = false;
        try {
            flag = this.saveNotify(arrangeMentInfoNotify.getMerchantprodMerchantArrangementInfoNotify().getMerchantprodMerchantArrangementInfoNotifyModel());
        }
        catch (Exception e) {
            logger.error("========= > \u6388\u6743/\u89e3\u7ea6\u6210\u529f\u901a\u77e5\u63a5\u53e3\uff1aant.mybank.merchantprod.merchant.arrangement.info.notify:" + e.getMessage());
        }
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u6388\u6743/\u89e3\u7ea6\u6210\u529f\u901a\u77e5\u63a5\u53e3\uff1aant.mybank.merchantprod.merchant.arrangement.info.notify", "1", context, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(MerchantprodMerchantArrangementInfoNotifyModel model) {
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(model.getMerchantId());
        if (dto == null) {
            return false;
        }
        if (model.getArrangementStatus().equals(dto.getArrangementStatus())) {
            return true;
        }
        HuifuWalletAccount hwa = (HuifuWalletAccount)this.huifuWalletAccountDao.selectById(dto.getId());
        hwa.setArrangementStatus(model.getArrangementStatus());
        hwa.setArrangementNo(model.getArrangementNo());
        if ("INVALID_TO_BE_CONFIRM".equals(model.getArrangementStatus()) || "UN_VALID".equals(model.getArrangementStatus())) {
            hwa.setAcctStat("F");
            hwa.setFailReason("\u5408\u7ea6\u672a\u786e\u8ba4\u6216\u65e0\u6548");
        } else if ("NOT_EXIST".equals(model.getArrangementStatus())) {
            hwa.setFailReason("\u5408\u7ea6\u4e0d\u5b58\u5728");
            hwa.setAcctStat("C");
        } else {
            hwa.setFailReason("");
            hwa.setAcctStat("N");
        }
        hwa.setUpdateTime(new Date());
        this.huifuWalletAccountDao.updateById(hwa);
        return true;
    }
}

