/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWalletAccount;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.MerchantprodMerchAsyncUpdateMerchantNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.MerchantprodMerchAsyncUpdateMerchantNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import com.zbkj.service.wangshang.notify.service.impl.BkcloudfundsProtocolWithholdResultNotifyServiceImpl;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkMerchantprodMerchAsyncUpdateMerchantNotifyService")
public class BkMerchantprodMerchAsyncUpdateMerchantNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsProtocolWithholdResultNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > \u5546\u6237\u4fee\u6539\u7ed3\u679c\u901a\u77e5\uff08\u5f02\u6b65\u901a\u77e5\uff09:ant.mybank.merchantprod.merch.async.updateMerchant.notify");
        logger.info("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        MerchantprodMerchAsyncUpdateMerchantNotifyRequest merchantprodMerchAsyncUpdateMerchantNotifyRequest = XmlConverter.getInstance().toResponse(context, MerchantprodMerchAsyncUpdateMerchantNotifyRequest.class);
        RequestHead head = merchantprodMerchAsyncUpdateMerchantNotifyRequest.getMerchantprodMerchAsyncUpdateMerchantNotify().getRequestHead();
        boolean flag = false;
        try {
            flag = this.saveNotify(merchantprodMerchAsyncUpdateMerchantNotifyRequest.getMerchantprodMerchAsyncUpdateMerchantNotify().getMerchantprodMerchAsyncUpdateMerchantNotifyModel());
        }
        catch (Exception e) {
            logger.error("========= > \u5546\u6237\u4fee\u6539\u7ed3\u679c\u901a\u77e5\uff08\u5f02\u6b65\u901a\u77e5\uff09:ant.mybank.merchantprod.merch.async.updateMerchant.notify:" + e.getMessage());
        }
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u5546\u6237\u4fee\u6539\u7ed3\u679c\u901a\u77e5\uff08\u5f02\u6b65\u901a\u77e5\uff09:ant.mybank.merchantprod.merch.async.updateMerchant.notify", "1", context, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(MerchantprodMerchAsyncUpdateMerchantNotifyModel model) {
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(model.getMerchantId());
        if (dto == null) {
            return false;
        }
        Date now = new Date();
        HuifuWalletAccount hwa = (HuifuWalletAccount)this.huifuWalletAccountDao.selectById(dto.getId());
        String status = model.getStatus();
        hwa.setUpdateTime(now);
        if ("1".equals(status)) {
            hwa.setAcctStat("N");
            hwa.setFailReason("");
        } else if ("2".equals(status)) {
            hwa.setAcctStat("F");
            hwa.setFailReason(model.getFailReason());
        }
        this.huifuWalletAccountDao.updateById(hwa);
        return true;
    }
}

