/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.request.YlyPrintRequest;
import com.zbkj.common.request.YlyPrintRequestGoods;
import com.zbkj.common.response.YlyAccessTokenResponse;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.util.yly.RequestMethod;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class YlyUtil {
    private static final Logger logger = LoggerFactory.getLogger(YlyUtil.class);
    private YlyAccessTokenResponse ylyAccessTokenResponse;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private RedisUtil redisUtil;
    private static String client_id = "";
    private static String client_secret = "";
    private static String machine_code = "";
    private static String msign = "";
    private static String status = "";

    public void instant() {
        if (ObjectUtil.isNotNull((Object)this.ylyAccessTokenResponse) && StringUtils.isNotBlank((CharSequence)this.ylyAccessTokenResponse.getBody().getAccess_token())) {
            return;
        }
        try {
            client_id = this.systemConfigService.getValueByKey("ylyprint_app_id");
            client_secret = this.systemConfigService.getValueByKey("ylyprint_app_secret");
            machine_code = this.systemConfigService.getValueByKey("ylyprint_app_machine_code");
            msign = this.systemConfigService.getValueByKey("ylyprint_app_machine_msign");
            status = this.systemConfigService.getValueByKey("ylyprint_status");
            if (StringUtils.isBlank((CharSequence)client_id) || StringUtils.isBlank((CharSequence)client_secret) || StringUtils.isBlank((CharSequence)machine_code) || StringUtils.isBlank((CharSequence)msign)) {
                throw new CrmebException("\u6613\u8054\u4e91\u914d\u7f6e\u6570\u636e\u4e0d\u5b8c\u6574");
            }
            if (StringUtils.isBlank((CharSequence)status) || "false".equals(status)) {
                return;
            }
            RequestMethod.init(client_id, client_secret);
            boolean exists = this.redisUtil.exists("yly_token");
            if (exists) {
                Object o = this.redisUtil.get("yly_token");
                this.ylyAccessTokenResponse = (YlyAccessTokenResponse)JSON.parseObject((String)o.toString(), YlyAccessTokenResponse.class);
            } else {
                this.ylyAccessTokenResponse = (YlyAccessTokenResponse)JSON.parseObject((String)RequestMethod.getAccessToken(), YlyAccessTokenResponse.class);
                this.redisUtil.set("yly_token", (Object)JSON.toJSONString((Object)this.ylyAccessTokenResponse), Long.valueOf(30L), TimeUnit.DAYS);
            }
            logger.info("\u83b7\u53d6\u7684\u6613\u8054\u4e91AccessToken:" + JSON.toJSONString((Object)this.ylyAccessTokenResponse));
            String addedPrint = RequestMethod.getInstance().addPrinter(machine_code, msign, this.ylyAccessTokenResponse.getBody().getAccess_token());
            logger.info("\u6dfb\u52a0\u6253\u5370\u673a\u7ed3\u679c:" + addedPrint);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u6613\u8054\u4e91\u6253\u5370\u673a\u5931\u8d25" + e.getMessage());
            logger.error(String.format("\u6613\u8054\u4e91 \u914d\u7f6e\u53c2\u6570 client_id=%s client_secret=%s machine_code=%s msign=%s", client_id, client_secret, machine_code, msign));
        }
    }

    public void ylyVoice() throws Exception {
        this.instant();
        RequestMethod.getInstance().printerSetVoice(this.ylyAccessTokenResponse.getBody().getAccess_token(), machine_code, "[\"CRMEB \u6765\u65b0\u5355\u4e86\",9,0]", "false", "0", "ORDER xxx");
        logger.info("\u8bbe\u7f6e\u8bed\u97f3\u6210\u529f");
    }

    public void ylySetSound(String responseType, String volume) throws Exception {
        this.instant();
        RequestMethod.getInstance().printSetSound(this.ylyAccessTokenResponse.getBody().getAccess_token(), machine_code, responseType, volume);
        logger.info("\u8bbe\u7f6e\u97f3\u91cf\u6210\u529f");
    }

    public void ylyCancelAll() throws Exception {
        this.instant();
        String cancelAllPrint = RequestMethod.getInstance().printCancelAll(this.ylyAccessTokenResponse.getBody().getAccess_token(), machine_code);
        logger.info("\u53d6\u6d88\u6389\u6240\u6709\u6253\u5370\u8ba2\u5355" + cancelAllPrint);
    }

    public void ylyPrint(YlyPrintRequest ylyPrintRequest) throws Exception {
        this.instant();
        String printSb = "<FH><FB><center>" + ylyPrintRequest.getBusinessName() + "</center></FB></FH>********************************<FH>\u8ba2\u5355\u7f16\u53f7\uff1a" + ylyPrintRequest.getOrderNo() + "\n\u65e5   \u671f\uff1a" + ylyPrintRequest.getDate() + "\n\u59d3   \u540d\uff1a" + ylyPrintRequest.getName() + "\n\u7535   \u8bdd\uff1a" + ylyPrintRequest.getPhone() + "\n\u5730   \u5740\uff1a" + ylyPrintRequest.getAddress() + "\n\u8ba2\u5355\u5907\u6ce8\uff1a" + ylyPrintRequest.getNote() + "</FH>\n********************************\n<FH>\u5546\u54c1\u540d\u79f0 \u5355\u4ef7 \u6570\u91cf \u91d1\u989d\n" + this.ylyPrintFormatGoodsList(ylyPrintRequest.getGoods()) + "</FH>********************************\n<FH><LR>\u5408\u8ba1\uff1a\u00a5" + ylyPrintRequest.getAmount() + "\u5143\uff0c\u4f18\u60e0\uff1a\u00a5" + ylyPrintRequest.getDiscount() + "\u5143</LR><LR>\u90ae\u8d39\uff1a\u00a5" + ylyPrintRequest.getPostal() + "\u5143\uff0c\u62b5\u6263\uff1a\u00a5" + ylyPrintRequest.getDeduction() + "\u5143</LR></FH><FH><right>\u5b9e\u9645\u652f\u4ed8\uff1a\u00a5" + ylyPrintRequest.getPayMoney() + "\u5143</right></FH><FB><FB><center>\u5b8c</center></FB></FB>";
        RequestMethod.getInstance().printIndex(this.ylyAccessTokenResponse.getBody().getAccess_token(), machine_code, URLEncoder.encode(printSb, "utf-8"), "order111");
    }

    public boolean checkYlyPrintAfterPaySuccess() {
        String printAuto = this.systemConfigService.getValueByKey("ylyprint_auto_status");
        return StrUtil.isNotBlank((CharSequence)printAuto) && "'0'".equals(printAuto);
    }

    public boolean checkYlyPrintStatus() {
        String printAuto = this.systemConfigService.getValueByKey("ylyprint_status");
        return StrUtil.isNotBlank((CharSequence)printAuto) && "'0'".equals(printAuto);
    }

    public String ylyPrintFormatGoodsList(List<YlyPrintRequestGoods> goods) {
        StringBuilder printGoodsString = new StringBuilder();
        for (YlyPrintRequestGoods goood : goods) {
            printGoodsString.append(goood.getGoodsName());
            printGoodsString.append(" ").append(goood.getUnitPrice());
            printGoodsString.append(" ").append(goood.getNum());
            printGoodsString.append(" ").append(goood.getMoney()).append("\n");
        }
        return printGoodsString.toString();
    }

    public static void main(String[] args) throws Exception {
        YlyUtil ylyUtil = new YlyUtil();
        ylyUtil.instant();
        ylyUtil.ylyVoice();
    }
}

