/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.constants.ClosingConstant;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.model.user.UserClosing;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.ClosingAuditRequest;
import com.zbkj.common.request.ClosingProofRequest;
import com.zbkj.common.request.ClosingRemarkRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserClosingSearchRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.UserClosingDao;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserClosingService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class UserClosingServiceImpl
extends ServiceImpl<UserClosingDao, UserClosing>
implements UserClosingService {
    @Resource
    private UserClosingDao dao;
    @Autowired
    private UserService userService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;

    @Override
    public PageInfo<UserClosing> getPageByUid(Integer uid, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserClosing::getUid, (Object)uid);
        lqw.orderByDesc(UserClosing::getId);
        List closingList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)closingList);
    }

    @Override
    public PageInfo<UserClosing> getPlatformPage(UserClosingSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.or()).like(UserClosing::getWechatNo, (Object)keywords)).or()).like(UserClosing::getCardholder, (Object)keywords)).or()).like(UserClosing::getBankCardNo, (Object)keywords)).or()).like(UserClosing::getAlipayAccount, (Object)keywords);
            });
        }
        if (ObjectUtil.isNotNull((Object)request.getAuditStatus())) {
            lqw.eq(UserClosing::getAuditStatus, (Object)request.getAuditStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getClosingType())) {
            lqw.eq(UserClosing::getClosingType, (Object)request.getClosingType());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            lqw.between(UserClosing::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        if (ObjectUtil.isNotNull((Object)request.getAccountStatus())) {
            lqw.eq(UserClosing::getAccountStatus, (Object)request.getAccountStatus());
        }
        lqw.orderByDesc(UserClosing::getId);
        List closingList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isNotEmpty((Collection)closingList)) {
            List<Integer> uidList = closingList.stream().map(UserClosing::getUid).distinct().collect(Collectors.toList());
            Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
            for (UserClosing userClosing : closingList) {
                userClosing.setNickName(Optional.ofNullable(userMap.get(userClosing.getUid()).getNickname()).orElse(""));
                userClosing.setIsLogoff(Optional.ofNullable(userMap.get(userClosing.getUid()).getIsLogoff()).orElse(false));
            }
        }
        return CommonPage.copyPageInfo((Page)page, (List)closingList);
    }

    @Override
    public Boolean userClosingAudit(ClosingAuditRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        UserClosing userClosing = this.getByClosingNo(request.getClosingNo());
        if (!userClosing.getAuditStatus().equals(ClosingConstant.CLOSING_AUDIT_STATUS_AUDIT)) {
            throw new CrmebException("\u63d0\u73b0\u7533\u8bf7\u5df2\u7ecf\u5904\u7406");
        }
        User user = (User)this.userService.getById(userClosing.getUid());
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException("\u7528\u6237\u6570\u636e\u5f02\u5e38");
        }
        userClosing.setAuditId(admin.getId());
        userClosing.setAuditTime((Date)DateUtil.date());
        UserBrokerageRecord brokerageRecord = this.userBrokerageRecordService.getOneByLinkNo(userClosing.getClosingNo());
        if (request.getAuditStatus().equals(ClosingConstant.CLOSING_AUDIT_STATUS_FAIL)) {
            userClosing.setRefusalReason(request.getRefusalReason());
            userClosing.setAuditStatus(ClosingConstant.CLOSING_AUDIT_STATUS_FAIL);
            brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_INVALIDATION);
            return (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(userClosing);
                this.userBrokerageRecordService.updateById(brokerageRecord);
                return Boolean.TRUE;
            });
        }
        userClosing.setAuditStatus(ClosingConstant.CLOSING_AUDIT_STATUS_SUCCESS);
        if (user.getBrokeragePrice().compareTo(userClosing.getClosingPrice()) < 0) {
            throw new CrmebException("\u7528\u6237\u4f63\u91d1\u4e0d\u8db3\uff0c\u5ba1\u6838\u65e0\u6cd5\u6210\u529f");
        }
        brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(userClosing);
            Boolean result = this.userService.updateBrokerage(user.getId(), userClosing.getClosingPrice(), "sub");
            if (!result.booleanValue()) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.userBrokerageRecordService.updateById(brokerageRecord);
            return Boolean.TRUE;
        });
    }

    @Override
    public UserClosing getByClosingNo(String closingNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserClosing::getClosingNo, (Object)closingNo);
        lqw.last(" limit 1");
        UserClosing userClosing = (UserClosing)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)userClosing)) {
            throw new CrmebException("\u7528\u6237\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        return userClosing;
    }

    @Override
    public Boolean proof(ClosingProofRequest request) {
        UserClosing userClosing = this.getByClosingNo(request.getClosingNo());
        if (!userClosing.getAuditStatus().equals(ClosingConstant.CLOSING_AUDIT_STATUS_SUCCESS)) {
            throw new CrmebException("\u7ed3\u7b97\u5355\u5ba1\u6838\u72b6\u6001\u5f02\u5e38!");
        }
        userClosing.setClosingProof(this.systemAttachmentService.clearPrefix(request.getClosingProof()));
        userClosing.setAccountStatus(ClosingConstant.CLOSING_ACCOUNT_STATUS_SUCCESS);
        userClosing.setClosingTime((Date)DateUtil.date());
        return this.updateById(userClosing);
    }

    @Override
    public Boolean remark(ClosingRemarkRequest request) {
        UserClosing userClosing = this.getByClosingNo(request.getClosingNo());
        userClosing.setMark(request.getRemark());
        return this.updateById(userClosing);
    }

    @Override
    public UserClosing getUserExtractByUserId(Integer userId) {
        QueryWrapper qw = new QueryWrapper();
        qw.select(new String[]{"SUM(closing_price) as closing_price,count(id) as id, uid"});
        qw.eq((Object)"audit_status", (Object)ClosingConstant.CLOSING_AUDIT_STATUS_SUCCESS);
        qw.eq((Object)"account_status", (Object)ClosingConstant.CLOSING_ACCOUNT_STATUS_SUCCESS);
        qw.eq((Object)"uid", (Object)userId);
        qw.groupBy((Object)"uid");
        UserClosing userClosing = (UserClosing)this.dao.selectOne((Wrapper)qw);
        if (ObjectUtil.isNull((Object)userClosing)) {
            userClosing = new UserClosing();
            userClosing.setId(Integer.valueOf(0));
            userClosing.setClosingPrice(BigDecimal.ZERO);
        }
        return userClosing;
    }

    @Override
    public List<UserClosing> findByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserClosing::getAuditStatus, (Object)ClosingConstant.CLOSING_AUDIT_STATUS_SUCCESS);
        lqw.eq(UserClosing::getAccountStatus, (Object)ClosingConstant.CLOSING_ACCOUNT_STATUS_SUCCESS);
        lqw.apply("date_format(update_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }
}

