/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.constants.BillConstants;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.constants.GroupDataConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bill.Bill;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.model.user.UserClosing;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BrokerageToYueRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.RetailStoreSubUserSearchRequest;
import com.zbkj.common.request.UserClosingApplyRequest;
import com.zbkj.common.request.UserSpreadPeopleRequest;
import com.zbkj.common.request.UserUpdateSpreadRequest;
import com.zbkj.common.response.BrokerageRecordDetailResponse;
import com.zbkj.common.response.PromotionOrderResponse;
import com.zbkj.common.response.RetailStorePosterBannerResponse;
import com.zbkj.common.response.SpreadUserResponse;
import com.zbkj.common.response.UserClosingConfigResponse;
import com.zbkj.common.response.UserClosingRecordResponse;
import com.zbkj.common.response.UserSpreadOrderMonthResponse;
import com.zbkj.common.response.UserSpreadOrderResponse;
import com.zbkj.common.response.UserSpreadPeopleItemResponse;
import com.zbkj.common.response.UserSpreadPeopleTeamNumResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.vo.RetailStoreConfigVo;
import com.zbkj.service.service.BillService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.RetailStoreService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemGroupDataService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserClosingService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class RetailStoreServiceImpl
implements RetailStoreService {
    @Autowired
    private UserService userService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;
    @Autowired
    private SystemGroupDataService systemGroupDataService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserClosingService userClosingService;
    @Autowired
    private BillService billService;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;
    @Autowired
    private OrderService orderService;

    @Override
    public RetailStoreConfigVo getRetailStoreConfig() {
        RetailStoreConfigVo vo = new RetailStoreConfigVo();
        vo.setRetailStoreSwitch(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_switch"))));
        vo.setRetailStoreLine(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_line"))));
        vo.setRetailStoreBindingType(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_binding_type"))));
        vo.setRetailStoreBubbleSwitch(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_bubble_switch"))));
        vo.setRetailStoreBrokerageFirstRatio(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_first_ratio"))));
        vo.setRetailStoreBrokerageSecondRatio(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_second_ratio"))));
        vo.setRetailStoreBrokerageFreezingTime(Integer.valueOf(Integer.parseInt(this.systemConfigService.getValueByKey("retail_store_brokerage_freezing_time"))));
        vo.setRetailStoreExtractMinPrice(new BigDecimal(this.systemConfigService.getValueByKey("retail_store_extract_min_price")));
        vo.setRetailStoreExtractBank(this.systemConfigService.getValueByKey("retail_store_extract_bank").replace("\\n", "\n"));
        return vo;
    }

    @Override
    public Boolean saveRetailStoreConfig(RetailStoreConfigVo retailStoreConfigVo) {
        int ration = retailStoreConfigVo.getRetailStoreBrokerageFirstRatio() + retailStoreConfigVo.getRetailStoreBrokerageSecondRatio();
        if (ration > this.crmebConfig.getRetailStoreBrokerageRatio() || ration < 0) {
            throw new CrmebException(StrUtil.format((CharSequence)"\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u8303\u56f4\u4e3a 0 ~ {}", (Object[])new Object[]{this.crmebConfig.getRetailStoreBrokerageRatio()}));
        }
        this.systemConfigService.updateOrSaveValueByName("retail_store_switch", retailStoreConfigVo.getRetailStoreSwitch().toString());
        this.systemConfigService.updateOrSaveValueByName("retail_store_line", retailStoreConfigVo.getRetailStoreLine().toString());
        this.systemConfigService.updateOrSaveValueByName("retail_store_binding_type", retailStoreConfigVo.getRetailStoreBindingType().toString());
        this.systemConfigService.updateOrSaveValueByName("retail_store_bubble_switch", retailStoreConfigVo.getRetailStoreBubbleSwitch().toString());
        this.systemConfigService.updateOrSaveValueByName("retail_store_brokerage_first_ratio", retailStoreConfigVo.getRetailStoreBrokerageFirstRatio().toString());
        this.systemConfigService.updateOrSaveValueByName("retail_store_brokerage_second_ratio", retailStoreConfigVo.getRetailStoreBrokerageSecondRatio().toString());
        this.systemConfigService.updateOrSaveValueByName("retail_store_brokerage_freezing_time", retailStoreConfigVo.getRetailStoreBrokerageFreezingTime().toString());
        this.systemConfigService.updateOrSaveValueByName("retail_store_extract_min_price", retailStoreConfigVo.getRetailStoreExtractMinPrice().toString());
        this.systemConfigService.updateOrSaveValueByName("retail_store_extract_bank", retailStoreConfigVo.getRetailStoreExtractBank());
        return true;
    }

    @Override
    public Integer getSpreadOrderCount() {
        Integer uid = this.userService.getUserIdException();
        return this.userBrokerageRecordService.getSpreadCountByUid(uid);
    }

    @Override
    public List<UserSpreadOrderMonthResponse> getSpreadOrder(PageParamRequest pageParamRequest) {
        User user = this.userService.getInfo();
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException("\u7528\u6237\u6570\u636e\u5f02\u5e38");
        }
        List<UserBrokerageRecord> recordList = this.userBrokerageRecordService.findSpreadListByUid(user.getId(), pageParamRequest);
        if (CollUtil.isEmpty(recordList)) {
            return CollUtil.newArrayList((Object[])new UserSpreadOrderMonthResponse[0]);
        }
        List<Integer> uidList = recordList.stream().map(UserBrokerageRecord::getSubUid).distinct().collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        ArrayList<UserSpreadOrderMonthResponse> orderMonthResponseArrayList = new ArrayList<UserSpreadOrderMonthResponse>();
        ArrayList monthList = CollUtil.newArrayList((Object[])new String[0]);
        recordList.forEach(record -> {
            UserSpreadOrderResponse userSpreadOrderResponse = new UserSpreadOrderResponse();
            userSpreadOrderResponse.setOrderNo(record.getLinkNo());
            userSpreadOrderResponse.setTime(record.getUpdateTime());
            userSpreadOrderResponse.setAmount(record.getPrice());
            userSpreadOrderResponse.setAvatar(((User)userMap.get(record.getSubUid())).getAvatar());
            userSpreadOrderResponse.setNickname(((User)userMap.get(record.getSubUid())).getNickname());
            userSpreadOrderResponse.setType("\u8fd4\u4f63");
            String month = CrmebDateUtil.dateToStr((Date)record.getUpdateTime(), (String)"yyyy-MM");
            if (monthList.contains(month)) {
                for (UserSpreadOrderMonthResponse orderMonthResponse : orderMonthResponseArrayList) {
                    if (!orderMonthResponse.getTime().equals(month)) continue;
                    orderMonthResponse.getChild().add(userSpreadOrderResponse);
                    break;
                }
            } else {
                UserSpreadOrderMonthResponse orderMonthResponse = new UserSpreadOrderMonthResponse();
                orderMonthResponse.setTime(month);
                orderMonthResponse.setChild((List)CollUtil.newArrayList((Object[])new UserSpreadOrderResponse[]{userSpreadOrderResponse}));
                orderMonthResponseArrayList.add(orderMonthResponse);
                monthList.add(month);
            }
        });
        Map<String, Integer> countMap = this.userBrokerageRecordService.getSpreadCountByUidAndMonth(user.getId(), monthList);
        for (UserSpreadOrderMonthResponse userSpreadOrderItemResponse : orderMonthResponseArrayList) {
            userSpreadOrderItemResponse.setCount(countMap.get(userSpreadOrderItemResponse.getTime()));
        }
        return orderMonthResponseArrayList;
    }

    @Override
    public UserSpreadPeopleTeamNumResponse getSpreadPeopleTeamNum() {
        UserSpreadPeopleTeamNumResponse response = new UserSpreadPeopleTeamNumResponse();
        List<Integer> userIdList = new ArrayList<Integer>();
        Integer userId = this.userService.getUserIdException();
        userIdList.add(userId);
        userIdList = this.userService.getSpreadPeopleIdList(userIdList);
        if (CollUtil.isEmpty(userIdList)) {
            response.setCount(Integer.valueOf(0));
            response.setFirstSpreadNum(Integer.valueOf(0));
            response.setSecondSpreadNum(Integer.valueOf(0));
            return response;
        }
        response.setFirstSpreadNum(Integer.valueOf(userIdList.size()));
        List<Integer> secondSpreadIdList = this.userService.getSpreadPeopleIdList(userIdList);
        if (CollUtil.isEmpty(secondSpreadIdList)) {
            response.setSecondSpreadNum(Integer.valueOf(0));
            response.setCount(response.getFirstSpreadNum());
            return response;
        }
        response.setSecondSpreadNum(Integer.valueOf(secondSpreadIdList.size()));
        response.setCount(Integer.valueOf(response.getFirstSpreadNum() + response.getSecondSpreadNum()));
        return response;
    }

    @Override
    public List<UserSpreadPeopleItemResponse> getSpreadPeopleList(UserSpreadPeopleRequest request, PageParamRequest pageParamRequest) {
        Integer userId = this.userService.getUserIdException();
        List<Integer> userIdList = new ArrayList<Integer>();
        userIdList.add(userId);
        userIdList = this.userService.getSpreadPeopleIdList(userIdList);
        if (CollUtil.isEmpty(userIdList)) {
            return new ArrayList<UserSpreadPeopleItemResponse>();
        }
        if (request.getGrade().equals(1)) {
            List<Integer> secondSpreadIdList = this.userService.getSpreadPeopleIdList(userIdList);
            if (CollUtil.isEmpty(secondSpreadIdList)) {
                return new ArrayList<UserSpreadPeopleItemResponse>();
            }
            userIdList.clear();
            userIdList.addAll(secondSpreadIdList);
        }
        return this.userService.getSpreadPeopleList(userId, userIdList, request.getKeyword(), request.getSortKey(), request.getIsAsc(), pageParamRequest);
    }

    @Override
    public List<User> getSpreadPeopleTopByDate(String type) {
        return this.userService.getSpreadPeopleTopByDate(type);
    }

    @Override
    public List<User> getBrokerageTopByDate(String type) {
        List<UserBrokerageRecord> recordList = this.userBrokerageRecordService.getBrokerageTopByDate(type);
        if (CollUtil.isEmpty(recordList)) {
            return CollUtil.newArrayList((Object[])new User[0]);
        }
        int i = 0;
        while (i < recordList.size()) {
            UserBrokerageRecord userBrokerageRecord = recordList.get(i);
            if (userBrokerageRecord.getPrice().compareTo(BigDecimal.ZERO) < 1) {
                recordList.remove(i);
                continue;
            }
            ++i;
        }
        if (CollUtil.isEmpty(recordList)) {
            return CollUtil.newArrayList((Object[])new User[0]);
        }
        List<Integer> uidList = recordList.stream().map(UserBrokerageRecord::getUid).collect(Collectors.toList());
        Map<Integer, User> userVoList = this.userService.getUidMapList(uidList);
        ArrayList userList = CollUtil.newArrayList((Object[])new User[0]);
        for (UserBrokerageRecord record : recordList) {
            User user = new User();
            User userVo = userVoList.get(record.getUid());
            user.setId(record.getUid());
            user.setAvatar(userVo.getAvatar());
            user.setBrokeragePrice(record.getPrice());
            user.setNickname(userVo.getNickname());
            userList.add(user);
        }
        return userList;
    }

    @Override
    public PageInfo<BrokerageRecordDetailResponse> getBrokerageRecord(PageParamRequest pageParamRequest) {
        Integer uid = this.userService.getUserIdException();
        PageInfo<UserBrokerageRecord> pageInfo = this.userBrokerageRecordService.findDetailListByUid(uid, pageParamRequest);
        List recordList = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)recordList)) {
            return CommonPage.copyPageInfo(pageInfo, (List)CollUtil.newArrayList((Object[])new BrokerageRecordDetailResponse[0]));
        }
        HashMap map = CollUtil.newHashMap();
        recordList.forEach(i -> {
            String month = StrUtil.subPre((CharSequence)CrmebDateUtil.dateToStr((Date)i.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (int)7);
            if (map.containsKey(month)) {
                ((List)map.get(month)).add(i);
            } else {
                ArrayList list = CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
                list.add(i);
                map.put(month, list);
            }
        });
        ArrayList responseList = CollUtil.newArrayList((Object[])new BrokerageRecordDetailResponse[0]);
        map.forEach((key, value) -> {
            BrokerageRecordDetailResponse response = new BrokerageRecordDetailResponse();
            response.setMonth(key);
            response.setList(value);
            responseList.add(response);
        });
        List collect = responseList.stream().sorted(Comparator.comparing(s -> DateUtil.parse((String)s.getMonth(), (String)"yyyy-MM").getTime(), Comparator.reverseOrder())).collect(Collectors.toList());
        return CommonPage.copyPageInfo(pageInfo, collect);
    }

    @Override
    public List<RetailStorePosterBannerResponse> getPosterBanner() {
        return this.systemGroupDataService.getListByGid(GroupDataConstants.GROUP_DATA_ID_SPREAD_BANNER_LIST, RetailStorePosterBannerResponse.class);
    }

    @Override
    public void bindingUser(Integer spreadPid) {
        this.userService.bindSpread(spreadPid);
    }

    @Override
    public UserClosingConfigResponse getUserClosingConfig() {
        User user = this.userService.getInfo();
        String minPrice = this.systemConfigService.getValueByKeyException("retail_store_extract_min_price");
        String freezeDay = this.systemConfigService.getValueByKeyException("retail_store_brokerage_freezing_time");
        BigDecimal brokerage = user.getBrokeragePrice();
        BigDecimal freezeBrokerage = this.userBrokerageRecordService.getFreezePrice(user.getId());
        String bank = this.systemConfigService.getValueByKeyException("retail_store_extract_bank");
        UserClosingConfigResponse response = new UserClosingConfigResponse();
        response.setMinPrice(minPrice);
        response.setBrokerage(brokerage);
        response.setFreezeBrokerage(freezeBrokerage);
        response.setFreezeDay(freezeDay);
        if (StrUtil.isNotBlank((CharSequence)bank)) {
            response.setBankList(StrUtil.splitTrim((CharSequence)bank, (CharSequence)","));
        }
        return response;
    }

    @Override
    public Boolean userClosingApply(UserClosingApplyRequest request) {
        this.userClosingApplyValidate(request);
        User user = this.userService.getInfo();
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException("\u63d0\u73b0\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        BigDecimal money = user.getBrokeragePrice();
        if (money.compareTo(BigDecimal.ZERO) < 1) {
            throw new CrmebException("\u60a8\u5f53\u524d\u6ca1\u6709\u91d1\u989d\u53ef\u4ee5\u63d0\u73b0");
        }
        if (money.compareTo(request.getClosingPrice()) < 0) {
            throw new CrmebException("\u4f60\u5f53\u524d\u6700\u591a\u53ef\u63d0\u73b0 " + money + "\u5143");
        }
        UserClosing userClosing = new UserClosing();
        userClosing.setClosingType(request.getType());
        BeanUtils.copyProperties((Object)request, (Object)userClosing);
        userClosing.setUid(user.getId());
        userClosing.setBalance(money.subtract(request.getClosingPrice()));
        userClosing.setClosingNo(CrmebUtil.getOrderNo((String)"CU"));
        if (StrUtil.isNotBlank((CharSequence)userClosing.getPaymentCode())) {
            userClosing.setPaymentCode(this.systemAttachmentService.clearPrefix(userClosing.getPaymentCode()));
        }
        UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
        brokerageRecord.setUid(user.getId());
        brokerageRecord.setLinkType("withdraw");
        brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_SUB);
        brokerageRecord.setTitle("\u63d0\u73b0\u7533\u8bf7");
        brokerageRecord.setPrice(userClosing.getClosingPrice());
        brokerageRecord.setBalance(money.subtract(userClosing.getClosingPrice()));
        brokerageRecord.setMark(StrUtil.format((CharSequence)"\u63d0\u73b0\u7533\u8bf7\u6263\u9664\u4f63\u91d1{}", (Object[])new Object[]{userClosing.getClosingPrice()}));
        brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_WITHDRAW);
        brokerageRecord.setCreateTime((Date)DateUtil.date());
        brokerageRecord.setLinkNo(userClosing.getClosingNo());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userClosingService.save(userClosing);
            this.userBrokerageRecordService.save(brokerageRecord);
            return Boolean.TRUE;
        });
        return execute;
    }

    @Override
    public List<UserClosingRecordResponse> getUserClosingRecord(PageParamRequest pageParamRequest) {
        Integer uid = this.userService.getUserIdException();
        PageInfo<UserClosing> pageInfo = this.userClosingService.getPageByUid(uid, pageParamRequest);
        List closingList = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)closingList)) {
            return CollUtil.newArrayList((Object[])new UserClosingRecordResponse[0]);
        }
        ArrayList<UserClosingRecordResponse> closingRecordResponseList = new ArrayList<UserClosingRecordResponse>();
        ArrayList monthList = CollUtil.newArrayList((Object[])new String[0]);
        closingList.forEach(record -> {
            String month = CrmebDateUtil.dateToStr((Date)record.getCreateTime(), (String)"yyyy-MM");
            if (monthList.contains(month)) {
                for (UserClosingRecordResponse closingRecordResponse : closingRecordResponseList) {
                    if (!closingRecordResponse.getMonth().equals(month)) continue;
                    closingRecordResponse.getList().add(record);
                    break;
                }
            } else {
                UserClosingRecordResponse closingRecordResponse = new UserClosingRecordResponse();
                closingRecordResponse.setMonth(month);
                closingRecordResponse.setList((List)CollUtil.newArrayList((Object[])new UserClosing[]{record}));
                closingRecordResponseList.add(closingRecordResponse);
                monthList.add(month);
            }
        });
        return closingRecordResponseList;
    }

    @Override
    public Boolean brokerageToYue(BrokerageToYueRequest request) {
        User user = this.userService.getInfo();
        if (user.getBrokeragePrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new CrmebException("\u7528\u6237\u65e0\u53ef\u7528\u4f63\u91d1");
        }
        if (user.getBrokeragePrice().compareTo(request.getPrice()) < 0) {
            throw new CrmebException("\u7528\u6237\u4f63\u91d1\u4e0d\u8db3");
        }
        BigDecimal price = request.getPrice();
        UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
        brokerageRecord.setUid(user.getId());
        brokerageRecord.setLinkNo("0");
        brokerageRecord.setLinkType("yue");
        brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_SUB);
        brokerageRecord.setTitle("\u4f63\u91d1\u8f6c\u4f59\u989d");
        brokerageRecord.setPrice(price);
        brokerageRecord.setBalance(user.getNowMoney().add(price));
        brokerageRecord.setMark(StrUtil.format((CharSequence)"\u4f63\u91d1\u8f6c\u4f59\u989d\uff0c\u51cf\u5c11{}", (Object[])new Object[]{price}));
        brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
        brokerageRecord.setCreateTime((Date)DateUtil.date());
        UserBalanceRecord balanceRecord = new UserBalanceRecord();
        balanceRecord.setUid(user.getId());
        balanceRecord.setLinkId("0");
        balanceRecord.setLinkType("brokerage");
        balanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
        balanceRecord.setAmount(price);
        balanceRecord.setBalance(user.getNowMoney().add(price));
        balanceRecord.setRemark(StrUtil.format((CharSequence)"\u4f63\u91d1\u8f6c\u4f59\u989d\u6210\u529f\uff0c\u6dfb\u52a0\u4f59\u989d{}\u5143", (Object[])new Object[]{price}));
        Bill bill = new Bill();
        bill.setUid(user.getId());
        bill.setPm(BillConstants.BILL_PM_ADD);
        bill.setAmount(price);
        bill.setType("brokerage");
        bill.setMark(StrUtil.format((CharSequence)"\u4f63\u91d1\u8f6c\u4f59\u989d\uff0c\u7528\u6237\u4f63\u91d1\u8f6c\u4f59\u989d{}\u5143", (Object[])new Object[]{price}));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean result = this.userService.brokerageToYue(user.getId(), brokerageRecord.getPrice());
            if (!result.booleanValue()) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.billService.save(bill);
            this.userBalanceRecordService.save(balanceRecord);
            this.userBrokerageRecordService.save(brokerageRecord);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u4f63\u91d1\u8f6c\u4f59\u989d\u5931\u8d25");
        }
        return execute;
    }

    @Override
    public Boolean updateUserSpread(UserUpdateSpreadRequest request) {
        Integer spreadUid;
        Integer userId = request.getUserId();
        if (userId.equals(spreadUid = request.getSpreadUid())) {
            throw new CrmebException("\u4e0a\u7ea7\u63a8\u5e7f\u4eba\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        User user = (User)this.userService.getById(userId);
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (user.getIsLogoff().booleanValue()) {
            throw new CrmebException("\u5df2\u6ce8\u9500\u7528\u6237\u4e0d\u53ef\u64cd\u4f5c");
        }
        if (user.getSpreadUid().equals(spreadUid)) {
            throw new CrmebException("\u5f53\u524d\u63a8\u5e7f\u4eba\u5df2\u7ecf\u662f\u6240\u9009\u4eba");
        }
        Integer oldSprUid = user.getSpreadUid();
        User spreadUser = (User)this.userService.getById(spreadUid);
        if (ObjectUtil.isNull((Object)spreadUser)) {
            throw new CrmebException("\u4e0a\u7ea7\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!spreadUser.getIsPromoter().booleanValue()) {
            throw new CrmebException("\u4e0a\u7ea7\u7528\u6237\u4e0d\u662f\u63a8\u5e7f\u5458");
        }
        if (spreadUser.getSpreadUid().equals(userId)) {
            throw new CrmebException("\u5f53\u524d\u7528\u6237\u5df2\u662f\u63a8\u5e7f\u4eba\u7684\u4e0a\u7ea7");
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.userService.updateSpreadByUid(userId, spreadUid);
            this.userService.updateSpreadCountByUid(spreadUid, "add");
            if (oldSprUid > 0) {
                this.userService.updateSpreadCountByUid(oldSprUid, "sub");
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean clearUserSpread(Integer id) {
        User user = (User)this.userService.getById(id);
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (user.getIsLogoff().booleanValue()) {
            throw new CrmebException("\u5df2\u6ce8\u9500\u7528\u6237\u4e0d\u53ef\u64cd\u4f5c");
        }
        if (ObjectUtil.isNull((Object)user.getSpreadUid()) || user.getSpreadUid() <= 0) {
            return Boolean.TRUE;
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.userService.updateSpreadByUid(user.getId(), 0);
            if (user.getSpreadUid() > 0) {
                this.userService.updateSpreadCountByUid(user.getSpreadUid(), "sub");
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public PageInfo<SpreadUserResponse> getRetailStorePeoplePage(String org, Integer userType, String keywords, String dateLimit, PageParamRequest pageRequest) {
        List<Integer> orgList = this.userService.getCompanyUserIdListByRealName(org);
        PageInfo<User> userPageInfo = this.userService.getRetailStorePeoplePage(orgList, userType, keywords, dateLimit, pageRequest);
        if (CollUtil.isEmpty((Collection)userPageInfo.getList())) {
            return CommonPage.copyPageInfo(userPageInfo, (List)CollUtil.newArrayList((Object[])new SpreadUserResponse[0]));
        }
        List userList = userPageInfo.getList();
        ArrayList responseList = CollUtil.newArrayList((Object[])new SpreadUserResponse[0]);
        userList.forEach(user -> {
            SpreadUserResponse userResponse = new SpreadUserResponse();
            BeanUtils.copyProperties((Object)user, (Object)userResponse);
            userResponse.setSpreadNickname("\u65e0");
            if (ObjectUtil.isNotNull((Object)user.getSpreadUid()) && user.getSpreadUid() > 0) {
                User spreadUser = (User)this.userService.getById(user.getSpreadUid());
                userResponse.setSpreadNickname(Optional.ofNullable(spreadUser.getNickname()).orElse("--"));
                userResponse.setBrokerageUserOrg(Optional.ofNullable(spreadUser.getRealName()).orElse("--"));
                userResponse.setBrokerageUserType(Integer.valueOf(2));
            } else {
                userResponse.setBrokerageUserOrg(user.getRealName());
                userResponse.setBrokerageUserType(Integer.valueOf(1));
            }
            List<UserBrokerageRecord> recordList = this.userBrokerageRecordService.getSpreadListByUid(user.getId());
            if (CollUtil.isEmpty(recordList)) {
                userResponse.setSpreadOrderNum(Integer.valueOf(0));
                userResponse.setSpreadOrderTotalPrice(BigDecimal.ZERO);
                userResponse.setTotalBrokeragePrice(BigDecimal.ZERO);
                userResponse.setExtractCountPrice(BigDecimal.ZERO);
                userResponse.setExtractCountNum(Integer.valueOf(0));
                userResponse.setFreezeBrokeragePrice(BigDecimal.ZERO);
            } else {
                userResponse.setSpreadOrderNum(Integer.valueOf(recordList.size()));
                userResponse.setTotalBrokeragePrice(recordList.stream().map(UserBrokerageRecord::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
                List<String> orderNoList = recordList.stream().map(UserBrokerageRecord::getLinkNo).collect(Collectors.toList());
                BigDecimal spreadOrderTotalPrice = this.orderService.getSpreadOrderTotalPriceByOrderList(orderNoList);
                userResponse.setSpreadOrderTotalPrice(spreadOrderTotalPrice);
                UserClosing userClosing = this.userClosingService.getUserExtractByUserId(user.getId());
                userResponse.setExtractCountPrice(userClosing.getClosingPrice());
                userResponse.setExtractCountNum(userClosing.getId());
                userResponse.setFreezeBrokeragePrice(this.userBrokerageRecordService.getFreezePrice(user.getId()));
            }
            responseList.add(userResponse);
        });
        return CommonPage.copyPageInfo(userPageInfo, (List)responseList);
    }

    @Override
    public PageInfo<User> getRetailStoreSubUserList(RetailStoreSubUserSearchRequest request, PageParamRequest pageRequest) {
        return this.userService.getRetailStoreSubUserList(request, pageRequest);
    }

    @Override
    public PageInfo<PromotionOrderResponse> getPromotionOrderList(RetailStoreSubUserSearchRequest request, PageParamRequest pageRequest) {
        PageInfo<UserBrokerageRecord> recordPageInfo;
        if (ObjectUtil.isNull((Object)request.getType())) {
            request.setType(Integer.valueOf(0));
        }
        if (CollUtil.isEmpty((Collection)(recordPageInfo = this.userBrokerageRecordService.findAdminSpreadListByUid(request, pageRequest)).getList())) {
            return CommonPage.copyPageInfo(recordPageInfo, (List)CollUtil.newArrayList((Object[])new PromotionOrderResponse[0]));
        }
        List<Integer> uidList = recordPageInfo.getList().stream().map(UserBrokerageRecord::getSubUid).collect(Collectors.toList());
        Map<Integer, User> userMap = this.userService.getUidMapList(uidList);
        List responseList = recordPageInfo.getList().stream().map(e -> {
            PromotionOrderResponse response = new PromotionOrderResponse();
            Order order = this.orderService.getByOrderNo(e.getLinkNo());
            response.setId(order.getId());
            response.setOrderNo(order.getOrderNo());
            response.setNickname(((User)userMap.get(e.getSubUid())).getNickname());
            response.setPrice(e.getPrice());
            response.setUpdateTime(e.getUpdateTime());
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo(recordPageInfo, responseList);
    }

    private void userClosingApplyValidate(UserClosingApplyRequest request) {
        if (request.getType().equals("bank")) {
            if (StrUtil.isBlank((CharSequence)request.getCardholder())) {
                throw new CrmebException("\u8bf7\u586b\u5199\u6301\u5361\u4eba\u59d3\u540d");
            }
            if (StrUtil.isBlank((CharSequence)request.getBankName())) {
                throw new CrmebException("\u8bf7\u9009\u62e9\u94f6\u884c");
            }
            if (StrUtil.isBlank((CharSequence)request.getBankCardNo())) {
                throw new CrmebException("\u8bf7\u586b\u5199\u94f6\u884c\u5361\u5361\u53f7");
            }
        }
        if (request.getType().equals("alipay") && StrUtil.isBlank((CharSequence)request.getAlipayAccount())) {
            throw new CrmebException("\u8bf7\u586b\u5199\u652f\u4ed8\u5b9d\u8d26\u53f7");
        }
        if (request.getType().equals("wechat")) {
            if (StrUtil.isBlank((CharSequence)request.getWechatNo())) {
                throw new CrmebException("\u8bf7\u586b\u5199\u5fae\u4fe1\u53f7");
            }
            if (StrUtil.isBlank((CharSequence)request.getPaymentCode())) {
                throw new CrmebException("\u8bf7\u586b\u5199\u5fae\u4fe1\u6536\u6b3e\u7801");
            }
            if (StrUtil.isBlank((CharSequence)request.getRealName())) {
                throw new CrmebException("\u8bf7\u586b\u5199\u771f\u5b9e\u59d3\u540d");
            }
        }
        String minPrice = this.systemConfigService.getValueByKeyException("retail_store_extract_min_price");
        if (request.getClosingPrice().compareTo(new BigDecimal(minPrice)) < 0) {
            throw new CrmebException(StrUtil.format((CharSequence)"\u6700\u4f4e\u63d0\u73b0\u91d1\u989d{}\u5143", (Object[])new Object[]{minPrice}));
        }
    }
}

