/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.huifu.bspay.sdk.opps.core.utils.RsaUtils;
import com.zbkj.bcx.cores.LockConstant;
import com.zbkj.bcx.cores.components.RetryProvider;
import com.zbkj.bcx.cores.exceptions.RetryableCoreException;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.HuifuRequestDataDto;
import com.zbkj.common.dto.HuifuWalletAccountDetailDto;
import com.zbkj.common.dto.HuifuWalletTradeDto;
import com.zbkj.common.dto.HuifuWalletTranslogDto;
import com.zbkj.common.excel.ExcelUtil;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.model.huifu.BankConfig;
import com.zbkj.common.model.huifu.HuifuWallet;
import com.zbkj.common.model.huifu.HuifuWalletAccountDetail;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.common.model.huifu.HuifuWalletTranslog;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.BankConfigDao;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletAccountDetailDao;
import com.zbkj.service.dao.HuifuWalletDao;
import com.zbkj.service.dao.HuifuWalletReconciliationDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.dao.HuifuWalletTranslogDao;
import com.zbkj.service.service.CommonWalletService;
import com.zbkj.service.service.HuifuReconcileService;
import com.zbkj.service.service.TransactionLogService;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CommonWalletServiceImpl
extends ServiceImpl<HuifuWalletDao, HuifuWallet>
implements CommonWalletService {
    private static final Logger logger = LoggerFactory.getLogger(CommonWalletService.class);
    @Resource
    private HuifuWalletAccountDetailDao huifuWalletAccountDetailDao;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Resource
    private BankConfigDao bankConfigDao;
    @Resource
    private HuifuWalletTranslogDao huifuWalletTranslogDao;
    @Resource
    private HuifuWalletReconciliationDao huifuWalletReconciliationDao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    HuifuReconcileService huifuReconcileService;
    @Autowired
    TransactionLogService transactionLogService;
    @Autowired
    private RedissonClient redisson;
    @Autowired
    private RetryProvider retryProvider;
    private static final String TRANSFERKEY = "Callback:";
    private static final int expireTime = 600;

    @Override
    public List<BankConfig> findBank(BankConfig bankConfig) throws CrmebWalletException {
        List<BankConfig> list = null;
        if (StringUtil.isEmpty((String)bankConfig.getBankCode()) && bankConfig.getBranchCode() == null && StringUtil.isEmpty((String)bankConfig.getBankName()) && StringUtil.isEmpty((String)bankConfig.getBranchName())) {
            String key = "BANKS-HEAD";
            if (this.redisUtil.exists(key).booleanValue()) {
                return (List)this.redisUtil.get(key);
            }
            list = this.bankConfigDao.findBankHead();
            this.redisUtil.set(key, list, Long.valueOf(600L), TimeUnit.MINUTES);
        } else {
            list = this.bankConfigDao.findBank(bankConfig);
            if (list.size() > 100) {
                throw new CrmebWalletException("\u652f\u884c\u540d\u79f0\u5173\u952e\u5b57\u4e0d\u591f\u7cbe\u786e");
            }
        }
        return list;
    }

    public static String RET(Map<String, Object> response, int type) {
        if (type == 1) {
            return response.get("resp_code").toString();
        }
        return response.get("resp_desc").toString();
    }

    @Override
    public PageInfo<HuifuWalletAccountDetail> thisHuifuWalletAccountTradeDetail(HuifuWalletAccountDetailDto dto) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageNumber() == null) {
            throw new CrmebWalletException("\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new CrmebWalletException("\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new CrmebWalletException("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new CrmebWalletException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dto.setStartDate(dto.getStartDate().replace("-", ""));
        dto.setEndDate(dto.getEndDate().replace("-", ""));
        dto.setIsHideCheck("1");
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<HuifuWalletAccountDetail> detailList = this.huifuWalletAccountDetailDao.selectByUniIdAndDate(dto);
        return new PageInfo(detailList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String huifuWalletRechargeCallback(HuifuRequestDataDto dto) {
        this.transactionLogService.save("huifuWalletRechargeCallback", "1", JSON.toJSONString((Object)dto), "ok", PaymentChannel.HUIFU.toString());
        if (!"00000000".equals(dto.getResp_code())) {
            return "";
        }
        if (!RsaUtils.verify((String)dto.getData(), (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsfgsLgysfEWahRJsczK4pox8qno3VIg9kBq7OBJcU/LBaGB+zaP3IU48tUH0ByE/7hO8VVtDy7EUJi0sMQgV57i0aU0FE6hXNnYw8mkkch08KkFhBD/UNxgTlr9fFScGkoB4uree3UbraZHPeeGc5ZB5nqlrcT64RT6Q19zP3zGAsTfR4YSRSV3zwg5eiJXfnwvRxKfjVUwg8TdhAZg5D+q1LrrAyKr7OcDHQ5z6uICBudp8E/mTvZEeUwB31qcY5viWQjtLnJ10qCPrhpf4N9MCYdVBpKh9Y1NklBHvb5Cui9bGzdnayOpDgGJ0SyIQvQGdNeJMlsQO3BNId4JzTwIDAQAB", (String)dto.getSign())) {
            logger.info("\u4f01\u4e1a\u94b1\u5305\u5145\u503c\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0cfail=\u9a8c\u7b7e\u5931\u8d25");
            return "";
        }
        Map response = (Map)JSON.parseObject((String)dto.getData(), Map.class);
        String status = Constants.tradeStatus((String)response.get("trans_stat").toString());
        String reqSeqId = response.get("reqSeqId").toString();
        String lockId = TRANSFERKEY + reqSeqId;
        RLock lock = this.redisson.getLock(lockId);
        try {
            if (lock.tryLock(3L, 10L, TimeUnit.SECONDS)) {
                logger.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                HuifuWalletTrade huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(response.get("hfSeqId").toString());
                if (status.equals(huifuWalletTrade.getTradeStatus())) {
                    String string = "RECV_ORD_ID_" + huifuWalletTrade.getHfSeqId();
                    return string;
                }
                Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                    huifuWalletTrade.setTransFinishTime(response.get("trans_date") + "" + response.get("trans_time"));
                    huifuWalletTrade.setErrorMsg(CommonWalletServiceImpl.RET(response, 2));
                    huifuWalletTrade.setTradeStatus(status);
                    huifuWalletTrade.setUpdateTime(new Date());
                    this.huifuWalletTradeDao.updateHuifuWalletTrade(huifuWalletTrade);
                    logger.info("\u4f01\u4e1a\u94b1\u5305\u5145\u503c\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc2={},errorMsg={}", (Object)reqSeqId, (Object)huifuWalletTrade.getErrorMsg());
                    return Boolean.TRUE;
                });
                if (!execute.booleanValue()) {
                    logger.error("\u4f01\u4e1a\u94b1\u5305\u5145\u503c\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5165\u5e93\u5931\u8d25\uff0crequest={}", (Object)response.get("resp_data").toString());
                    String string = "";
                    return string;
                }
                String string = "RECV_ORD_ID_" + reqSeqId;
                return string;
            }
            String huifuWalletTrade = "";
            return huifuWalletTrade;
        }
        catch (InterruptedException e2) {
            logger.error("huifuWalletRechargeCallback error", (Throwable)e2);
            String string = "";
            return string;
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                logger.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String huifuWalletExtractCallback(String messageBody) {
        Map<String, Object> response = this.pathToJson(messageBody);
        logger.info("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0c\u53c2\u6570\uff0cresponse={}", (Object)response.toString());
        this.transactionLogService.save("huifuWalletExtractCallback", "1", response.toString(), "ok", PaymentChannel.HUIFU.toString());
        if (!"00000000".equals(response.get("resp_code").toString())) {
            return "ok";
        }
        String sign = response.get("sign").toString();
        if (!RsaUtils.verify((String)response.get("resp_data").toString(), (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsfgsLgysfEWahRJsczK4pox8qno3VIg9kBq7OBJcU/LBaGB+zaP3IU48tUH0ByE/7hO8VVtDy7EUJi0sMQgV57i0aU0FE6hXNnYw8mkkch08KkFhBD/UNxgTlr9fFScGkoB4uree3UbraZHPeeGc5ZB5nqlrcT64RT6Q19zP3zGAsTfR4YSRSV3zwg5eiJXfnwvRxKfjVUwg8TdhAZg5D+q1LrrAyKr7OcDHQ5z6uICBudp8E/mTvZEeUwB31qcY5viWQjtLnJ10qCPrhpf4N9MCYdVBpKh9Y1NklBHvb5Cui9bGzdnayOpDgGJ0SyIQvQGdNeJMlsQO3BNId4JzTwIDAQAB", (String)sign)) {
            logger.info("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0cfail=\u9a8c\u7b7e\u5931\u8d25");
            return "";
        }
        JSONObject dataObj = JSON.parseObject((String)response.get("resp_data").toString());
        String reqSeqId = dataObj.getString("reqSeqId");
        String lockId = TRANSFERKEY + reqSeqId;
        RLock lock = this.redisson.getLock(lockId);
        try {
            if (lock.tryLock(3L, 10L, TimeUnit.SECONDS)) {
                logger.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                HuifuWalletTrade huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(dataObj.get((Object)"hfSeqId").toString());
                if ("1".equals(huifuWalletTrade.getTradeStatus())) {
                    logger.info("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc1={}", (Object)reqSeqId);
                    String string = "RECV_ORD_ID_" + reqSeqId;
                    return string;
                }
                Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                    huifuWalletTrade.setTransFinishTime(dataObj.get((Object)"req_date").toString());
                    huifuWalletTrade.setErrorMsg(CommonWalletServiceImpl.RET(response, 2));
                    huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)dataObj.get((Object)"trans_stat").toString()));
                    huifuWalletTrade.setUpdateTime(new Date());
                    this.huifuWalletTradeDao.updateHuifuWalletTrade(huifuWalletTrade);
                    logger.info("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc2={},errorMsg={}", (Object)reqSeqId, (Object)huifuWalletTrade.getErrorMsg());
                    return Boolean.TRUE;
                });
                if (!execute.booleanValue()) {
                    logger.error("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5165\u5e93\u5931\u8d25\uff0crequest={}", (Object)response.get("resp_data").toString());
                    String string = "";
                    return string;
                }
                String string = "RECV_ORD_ID_" + reqSeqId;
                return string;
            }
            String huifuWalletTrade = "";
            return huifuWalletTrade;
        }
        catch (InterruptedException e2) {
            logger.error("huifuWalletExtractCallback error", (Throwable)e2);
            String string = "";
            return string;
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                logger.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                lock.unlock();
            }
        }
    }

    private Map<String, Object> pathToJson(String urlData) {
        String data = null;
        try {
            data = URLDecoder.decode(urlData, "UTF-8");
        }
        catch (Exception e) {
            logger.error("\u89e3\u7801\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        Map collect = Arrays.stream(data.split("&")).map(str -> str.split("=")).collect(Collectors.toMap(x -> x[0], x -> ((String[])x).length == 2 ? x[1] : "", (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        return collect;
    }

    @Override
    public HuifuWalletTrade getWalletTradeInfo(HuifuWalletTrade huifuWalletTrade) throws CrmebWalletException {
        if (huifuWalletTrade.getId() == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeById(huifuWalletTrade.getId());
        return huifuWalletTrade;
    }

    @Override
    public String reconciliationReplay(String tradeDate) {
        this.huifuReconcileService.reconcileOrder(tradeDate, "6666000137445326");
        this.huifuReconcileService.reconcileSettle(tradeDate, "6666000137445326");
        this.huifuReconcileService.reconcileOutcash(tradeDate, "6666000137445326");
        this.huifuReconcileService.reconcileSplit(tradeDate, "6666000137445326");
        this.huifuReconcileService.reconcileSplitWS(tradeDate);
        return "1";
    }

    @Override
    public String createHuifuWalletReconciliation() {
        String[] days;
        for (String day : days = new String[]{DateUtils.formatDate((Date)DateUtils.addDays((Date)new Date(), (int)-2), (Object[])new Object[]{"yyyyMMdd"}), DateUtils.formatDate((Date)DateUtils.addDays((Date)new Date(), (int)-1), (Object[])new Object[]{"yyyyMMdd"}), DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyyMMdd"})}) {
            this.huifuReconcileService.reconcileOrder(day, "6666000137445326");
            this.huifuReconcileService.reconcileSettle(day, "6666000137445326");
            this.huifuReconcileService.reconcileOutcash(day, "6666000137445326");
            this.huifuReconcileService.reconcileSplit(day, "6666000137445326");
            this.huifuReconcileService.reconcileSplitWS(day);
        }
        return "1";
    }

    @Override
    public Map<String, Object> getHuifuWalletReconciliation(HuifuWalletTradeDto dto) throws CrmebWalletException {
        if (dto.getPageNumber() == null) {
            throw new CrmebWalletException("\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new CrmebWalletException("\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getFundFlowType())) {
            throw new CrmebWalletException("\u8d44\u91d1\u6d41\u5411\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNotEmpty((String)dto.getStartDate())) {
            dto.setStartDate(dto.getStartDate().replace("-", ""));
        }
        if (StringUtil.isNotEmpty((String)dto.getEndDate())) {
            dto.setEndDate(dto.getEndDate().replace("-", ""));
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, Object>> list = this.huifuWalletReconciliationDao.getWalletReconciliationList(dto);
        Map<String, Object> map = this.huifuWalletReconciliationDao.getWalletReconciliationSum(dto);
        PageInfo pageInfo = new PageInfo(list);
        if (map != null) {
            map.put("pageInfo", pageInfo);
        }
        return map;
    }

    @Override
    public String exportHuifuWalletReconciliation(HuifuWalletTradeDto dto, HttpServletResponse response) throws CrmebWalletException {
        if (StringUtil.isEmpty((String)dto.getFundFlowType())) {
            throw new CrmebWalletException("\u8d44\u91d1\u6d41\u5411\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getStartDate())) {
            dto.setStartDate(dto.getStartDate().replace("-", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getEndDate())) {
            dto.setEndDate(dto.getEndDate().replace("-", ""));
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "\u5bf9\u8d26\u6570\u636e" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u5bf9\u8d26\u6570\u636e");
            List<Map<String, Object>> list = this.huifuWalletReconciliationDao.getWalletReconciliationList(dto);
            CellStyle stringStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));
            Map<String, Object> map = this.huifuWalletReconciliationDao.getWalletReconciliationSum(dto);
            String headerTitle = "";
            headerTitle = map == null ? MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14 | \u603b\u91d1\u989d\uff1a\u3010{1}\u3011\u5143 | \u6210\u529f\u7b14\u6570\uff1a\u3010{2}\u3011\u7b14 | \u6210\u529f\u91d1\u989d\uff1a\u3010{3}\u3011\u5143 | \u5931\u8d25\u7b14\u6570\uff1a\u3010{4}\u3011\u7b14 | \u5931\u8d25\u91d1\u989d\uff1a\u3010{5}\u3011\u5143 | \u5904\u7406\u4e2d\u7b14\u6570\uff1a\u3010{6}\u3011\u7b14 | \u5904\u7406\u4e2d\u91d1\u989d\uff1a\u3010{7}\u3011\u5143", 0, 0, 0, 0, 0, 0, 0, 0) : MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14 | \u603b\u91d1\u989d\uff1a\u3010{1}\u3011\u5143 | \u6210\u529f\u7b14\u6570\uff1a\u3010{2}\u3011\u7b14 | \u6210\u529f\u91d1\u989d\uff1a\u3010{3}\u3011\u5143 | \u5931\u8d25\u7b14\u6570\uff1a\u3010{4}\u3011\u7b14 | \u5931\u8d25\u91d1\u989d\uff1a\u3010{5}\u3011\u5143 | \u5904\u7406\u4e2d\u7b14\u6570\uff1a\u3010{6}\u3011\u7b14 | \u5904\u7406\u4e2d\u91d1\u989d\uff1a\u3010{7}\u3011\u5143", String.valueOf(map.get("totalCount")), String.valueOf(map.get("sumAmount")), String.valueOf(map.get("successCount")), String.valueOf(map.get("successAmount")), String.valueOf(map.get("errorCount")), String.valueOf(map.get("errorAmount")), String.valueOf(map.get("processingCount")), String.valueOf(map.get("processingAmount")));
            HSSFCellStyle titleStyle1 = wb.createCellStyle();
            HSSFFont titleFont1 = wb.createFont();
            titleFont1.setFontHeightInPoints((short)11);
            titleFont1.setColor(HSSFColor.RED.index);
            titleFont1.setFontName("\u9ed1\u4f53");
            titleStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle1.setFont(titleFont1);
            titleStyle1.setWrapText(true);
            HSSFRow rowFirst = sheet1.createRow(0);
            rowFirst.setHeight((short)1000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 13));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle1);
            HSSFRow secondFirst = sheet1.createRow(1);
            String[] secondArr = new String[]{"\u5e8f\u53f7", "\u4ea4\u6613\u6d41\u6c34\u53f7", "\u94f6\u884c\u4ea4\u6613\u7c7b\u578b", "\u4ea4\u6613\u72b6\u6001", "\u4ea4\u6613\u8ba2\u5355\u521b\u5efa\u65f6\u95f4", "\u4ea4\u6613\u91d1\u989d", "\u51fa\u8d26\u65b9\u6237\u540d", "\u51fa\u8d26\u65b9\u8d26\u53f7", "\u51fa\u8d26\u65b9\u94f6\u884c", "\u5165\u8d26\u65b9\u6237\u540d", "\u5165\u8d26\u65b9\u8d26\u53f7", "\u5165\u8d26\u65b9\u94f6\u884c", "\u5165\u8d26\u65b9\u8bc1\u4ef6\u53f7", "\u5907\u6ce8", "\u652f\u4ed8\u6e20\u9053"};
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                int column = i == 0 ? 1500 : (i == 4 ? 5000 : (i == 1 || i == 7 || i == 10 || i == 13 ? 8000 : (i == 6 || i == 9 ? 10000 : (i == 13 ? 14000 : 4000))));
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(titleStyle);
            }
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }
            CellStyle greenStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.SEA_GREEN.index);
            CellStyle redStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.RED.index);
            CellStyle blueStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.BLUE.index);
            HSSFRow row = null;
            int rowIndex = 2;
            for (Map<String, Object> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue((double)(rowIndex - 1));
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("tradeSerialNo") != null ? result.get("tradeSerialNo").toString() : null);
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("bankTradeType") != null ? result.get("bankTradeType").toString() : null);
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("tradeStatus") != null ? result.get("tradeStatus").toString() : null);
                if (ObjectUtil.equal((Object)result.get("tradeStatus"), (Object)"\u4ea4\u6613\u6210\u529f")) {
                    cell3.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal((Object)result.get("tradeStatus"), (Object)"\u4ea4\u6613\u5931\u8d25")) {
                    cell3.setCellStyle(redStyle);
                } else {
                    cell3.setCellStyle(blueStyle);
                }
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("tradeStartTime") != null ? result.get("tradeStartTime").toString() : null);
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("tradeAmount") != null ? result.get("tradeAmount").toString() : null);
                cell5.setCellStyle(redStyle);
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("expendAccountName") != null ? result.get("expendAccountName").toString() : null);
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("expendAccountNo") != null ? result.get("expendAccountNo").toString() : null);
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("expendBank") != null ? result.get("expendBank").toString() : null);
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("incomeAccountName") != null ? result.get("incomeAccountName").toString() : null);
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("incomeAccountNo") != null ? result.get("incomeAccountNo").toString() : null);
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("incomeBank") != null ? result.get("incomeBank").toString() : null);
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("incomeCerNo") != null ? result.get("incomeCerNo").toString() : null);
                HSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(result.get("remark") != null ? result.get("remark").toString() : null);
                HSSFCell cell14 = row.createCell(14);
                cell14.setCellValue(result.get("payChannel") != null ? result.get("payChannel").toString() : null);
                ++rowIndex;
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new CrmebWalletException(e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return "0";
    }

    @Override
    public List<HuifuWalletTrade> getHuifuWalletTradeBySeqAndCode(HuifuWalletTrade huifuWalletTrade) throws CrmebWalletException {
        if (huifuWalletTrade.getBusinessCode() == null) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<HuifuWalletTrade> list = this.huifuWalletTradeDao.getHuifuWalletTradeBySeqAndCode(huifuWalletTrade);
        return list;
    }

    @Override
    public String exportHuifuWalletAccountTradeDetail(HuifuWalletAccountDetailDto dto, HttpServletResponse response) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new CrmebWalletException("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new CrmebWalletException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "\u6536\u652f\u660e\u7ec6" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u6536\u652f\u660e\u7ec6");
            dto.setStartDate(dto.getStartDate().replace("-", ""));
            dto.setEndDate(dto.getEndDate().replace("-", ""));
            dto.setIsHideCheck("1");
            List<HuifuWalletAccountDetail> detailList = this.huifuWalletAccountDetailDao.selectByUniIdAndDate(dto);
            CellStyle stringStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));
            String headerTitle = "";
            headerTitle = MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14", detailList.size());
            HSSFCellStyle titleStyle1 = wb.createCellStyle();
            HSSFFont titleFont1 = wb.createFont();
            titleFont1.setFontHeightInPoints((short)11);
            titleFont1.setColor(HSSFColor.RED.index);
            titleFont1.setFontName("\u9ed1\u4f53");
            titleStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle1.setFont(titleFont1);
            titleStyle1.setWrapText(true);
            HSSFRow rowFirst = sheet1.createRow(0);
            rowFirst.setHeight((short)1000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 13));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle1);
            HSSFRow secondFirst = sheet1.createRow(1);
            String[] secondArr = new String[]{"\u5e8f\u53f7", "\u4ea4\u6613\u6d41\u6c34\u53f7", "\u4e1a\u52a1\u6d41\u6c34\u53f7", "\u4ea4\u6613\u7c7b\u578b", "\u4ea4\u6613\u72b6\u6001", "\u521b\u5efa\u65f6\u95f4", "\u4ea4\u6613\u91d1\u989d", "\u4ea4\u6613\u540e\u4f59\u989d", "\u51fa\u8d26\u65b9\u540d\u79f0", "\u51fa\u8d26\u65b9\u5546\u6237\u53f7", "\u5165\u8d26\u65b9\u540d\u79f0", "\u5165\u8d26\u65b9\u5546\u6237\u53f7", "\u4ea4\u6613\u65e5\u671f", "\u4ea4\u6613\u65f6\u95f4", "\u5907\u6ce8", "\u652f\u4ed8\u6e20\u9053"};
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                int column = i == 0 ? 1500 : (i == 5 ? 5000 : (i == 1 || i == 2 || i == 8 || i == 10 ? 10000 : (i == 14 ? 14000 : 4000)));
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(titleStyle);
            }
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }
            CellStyle greenStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.SEA_GREEN.index);
            CellStyle redStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.RED.index);
            CellStyle blueStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.BLUE.index);
            HSSFRow row = null;
            int rowIndex = 2;
            for (HuifuWalletAccountDetail result : detailList) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue((double)(rowIndex - 1));
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.getTradeFlowNo() != null ? result.getTradeFlowNo().toString() : null);
                HSSFCell cell1_2 = row.createCell(2);
                cell1_2.setCellValue(result.getFlowNo() != null ? result.getFlowNo().toString() : null);
                HSSFCell cell2 = row.createCell(3);
                cell2.setCellValue(result.getTradeType() != null ? result.getTradeType().toString() : null);
                HSSFCell cell3 = row.createCell(4);
                cell3.setCellValue(result.getHandStatus() != null ? result.getHandStatus().toString() : null);
                if (ObjectUtil.equal((Object)result.getHandStatus(), (Object)"\u6210\u529f")) {
                    cell3.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal((Object)result.getHandStatus(), (Object)"\u5931\u8d25")) {
                    cell3.setCellStyle(redStyle);
                } else {
                    cell3.setCellStyle(blueStyle);
                }
                HSSFCell cell4 = row.createCell(5);
                cell4.setCellValue(result.getCreateDate() != null ? result.getCreateDate().toString() : null);
                HSSFCell cell5 = row.createCell(6);
                cell5.setCellValue(result.getAmount() != null ? result.getAmount().toString() : null);
                cell5.setCellStyle(redStyle);
                HSSFCell cell5_7 = row.createCell(7);
                cell5_7.setCellValue(result.getBalance() != null ? result.getBalance().toString() : null);
                HSSFCell cell6 = row.createCell(8);
                cell6.setCellValue(result.getAccountOutName() != null ? result.getAccountOutName().toString() : null);
                HSSFCell cell7 = row.createCell(9);
                cell7.setCellValue(result.getAccountOut() != null ? result.getAccountOut().toString() : null);
                HSSFCell cell8 = row.createCell(10);
                cell8.setCellValue(result.getAccountInName() != null ? result.getAccountInName().toString() : null);
                HSSFCell cell9 = row.createCell(11);
                cell9.setCellValue(result.getAccountIn() != null ? result.getAccountIn().toString() : null);
                HSSFCell cell10 = row.createCell(12);
                cell10.setCellValue(result.getTradeDate() != null ? result.getTradeDate().toString() : null);
                HSSFCell cell11 = row.createCell(13);
                cell11.setCellValue(result.getAccountsDealDate() != null ? result.getAccountsDealDate().toString() : null);
                HSSFCell cell12 = row.createCell(14);
                cell12.setCellValue(result.getMemo() != null ? result.getMemo().toString() : null);
                HSSFCell cell13 = row.createCell(15);
                cell13.setCellValue(result.getPayChannel() != null ? result.getPayChannel().toString() : null);
                ++rowIndex;
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new CrmebWalletException(e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return "0";
    }

    @Override
    public PageInfo<HuifuWalletTranslog> thisHuifuWalletTranslog(HuifuWalletTranslogDto dto) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageNumber() == null) {
            throw new CrmebWalletException("\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new CrmebWalletException("\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new CrmebWalletException("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new CrmebWalletException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        dto.setStartDate(dto.getStartDate().replace("-", ""));
        dto.setEndDate(dto.getEndDate().replace("-", ""));
        List<HuifuWalletTranslog> detailList = this.huifuWalletTranslogDao.selectByUniIdAndDate(dto);
        return new PageInfo(detailList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean modifyBalance(String uniId, BigDecimal amount, String payChannel) {
        RLock rLock = this.redisson.getLock(LockConstant.getBalance((String)uniId));
        try {
            rLock.lock();
            int affectedCount = (Integer)this.retryProvider.doExecute(() -> {
                String frozenAmount = this.huifuWalletAccountDao.getFrozenAmount(uniId, payChannel);
                int ret = this.huifuWalletAccountDao.updateSumFrozenAmount(uniId, frozenAmount, amount.add(new BigDecimal(frozenAmount)), payChannel);
                if (ret < 1) {
                    throw new RetryableCoreException();
                }
                return ret;
            });
            boolean bl = affectedCount > 0;
            return bl;
        }
        finally {
            rLock.unlock();
        }
    }
}

