/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.payment.services;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.zbkj.bcx.cores.components.JsonProvider;
import com.zbkj.bcx.cores.exceptions.BadCoreException;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.model.bcx.BcxPlatformFee;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.user.User;
import com.zbkj.payment.IocResolve;
import com.zbkj.payment.entities.PaymentTransactionEntity;
import com.zbkj.payment.mappers.PaymentTransactionMapper;
import com.zbkj.payment.mappers.dtos.PaymentStatusUpdateDTO;
import com.zbkj.service.payments.PaymentProvider;
import com.zbkj.service.payments.WalletPaymentService;
import com.zbkj.service.payments.commands.CreatePaymentCommand;
import com.zbkj.service.payments.commands.CreateTransferCommand;
import com.zbkj.service.payments.commands.DonePaymentCommand;
import com.zbkj.service.payments.commands.ReplenishOrderPlatformFeeCommand;
import com.zbkj.service.payments.results.PaymentCommandResult;
import com.zbkj.service.payments.snapshots.PaymentTradeSnapshot;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.bcx.BcxPlatformFeeService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Service
public class WalletPaymentServiceImpl
implements WalletPaymentService {
    private static final Logger logger = LoggerFactory.getLogger(WalletPaymentServiceImpl.class);
    private final OrderDetailService orderDetailService;
    private final OrderService orderService;
    private final BcxPlatformFeeService bcxPlatformFeeService;
    private final TransactionTemplate transactionTemplate;
    private final AsyncService asyncService;
    private final PaymentProvider paymentProvider;
    private final PaymentTransactionMapper paymentTransactionMapper;
    private final JsonProvider jsonProvider;

    public WalletPaymentServiceImpl(OrderDetailService orderDetailService, OrderService orderService, BcxPlatformFeeService bcxPlatformFeeService, TransactionTemplate transactionTemplate, SystemConfigService systemConfigService, AsyncService asyncService, IocResolve iocResolve, PaymentTransactionMapper paymentTransactionMapper, JsonProvider jsonProvider) {
        this.orderDetailService = orderDetailService;
        this.orderService = orderService;
        this.bcxPlatformFeeService = bcxPlatformFeeService;
        this.transactionTemplate = transactionTemplate;
        this.asyncService = asyncService;
        this.paymentTransactionMapper = paymentTransactionMapper;
        this.jsonProvider = jsonProvider;
        String channelName = systemConfigService.getValueByKey("pay_channel");
        this.paymentProvider = iocResolve.resolve(channelName, PaymentProvider.class);
    }

    public boolean dispatch(CreatePaymentCommand command) {
        Order order = command.getOrder();
        List orderDetails = this.orderDetailService.getByOrderNo(order.getOrderNo());
        List productIds = orderDetails.stream().map(OrderDetail::getProductId).collect(Collectors.toList());
        Integer bizType = this.orderService.getBizTypeByProductsType(productIds);
        Boolean walletBoolean = this.walletFreezeAndPay(order, (OrderDetail)orderDetails.get(0), bizType, command.getUser(), command.getMerchant());
        return walletBoolean;
    }

    public boolean dispatch(ReplenishOrderPlatformFeeCommand command) {
        if (CollectionUtils.isEmpty((Collection)command.getReplenishTransactionIds())) {
            throw new BadCoreException("\u8865\u507f\u652f\u4ed8\u7684Id\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PaymentTransactionEntity::getReqSeqId, command.getReplenishTransactionIds());
        lambdaQueryWrapper.in(PaymentTransactionEntity::getStatus, new Object[]{PaymentTransactionEntity.TransactionStatus.PENDING.ordinal()});
        lambdaQueryWrapper.in(PaymentTransactionEntity::getTransactionType, new Object[]{PaymentTransactionEntity.TransactionType.OrderPlatformFee.ordinal()});
        lambdaQueryWrapper = lambdaQueryWrapper.select(new SFunction[]{PaymentTransactionEntity::getReqSeqId, PaymentTransactionEntity::getSnapshotJson, PaymentTransactionEntity::getHfSeqId});
        List transactions = this.paymentTransactionMapper.selectMaps((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)transactions)) {
            throw new BadCoreException("\u672a\u627e\u5230\u7b26\u5408\u7684\u4ea4\u6613\u4fe1\u606f");
        }
        for (Map entity : transactions) {
            String snapshotJson = (String)entity.get("snapshot_json");
            String reqSeqId = (String)entity.get("reqSeqId");
            String hfSeqId = (String)entity.get("hf_seq_id");
            try {
                PaymentTradeSnapshot snapshot = (PaymentTradeSnapshot)this.jsonProvider.toObject(snapshotJson, PaymentTradeSnapshot.class);
                this.paymentProvider.doForPlatformTransfer(snapshot);
            }
            catch (Exception ex) {
                this.transactionTemplate.execute(t -> {
                    this.paymentTransactionMapper.updateStatus(PaymentStatusUpdateDTO.create(reqSeqId, hfSeqId, PaymentTransactionEntity.TransactionStatus.FAILED, ex.toString()));
                    return Boolean.TRUE;
                });
                logger.error("\u5e73\u53f0\u8d39\u7528\u652f\u4ed8\u5f02\u5e38:{}", (Object)reqSeqId, (Object)ex);
            }
        }
        return false;
    }

    private Boolean walletFreezeAndPay(Order order, OrderDetail orderDetail, Integer bizType, User user, Merchant merchant) {
        BcxPlatformFee platFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), Integer.valueOf(0));
        String productDesc = orderDetail.getProductName() + "(" + orderDetail.getSku() + ") * " + orderDetail.getPayNum();
        PaymentCommandResult paymentCommandResult = null;
        if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
            CreateTransferCommand command = new CreateTransferCommand();
            command.setAmount(order.getPayPrice().toPlainString()).setBusinessCode(bizType.toString()).setBusinessPartnerSeq(order.getOrderNo()).setComment(productDesc).setGoodsName(orderDetail.getProductName()).setGoodsUnit(orderDetail.getSku()).setGoodsNumber(String.valueOf(orderDetail.getPayNum())).setInId(merchant.getIdentityNo()).setSellFeePriority(platFee.getTransPriority()).setNeedActiveCode("0").setOutId(user.getIdentityNo()).setPlatAmount(platFee.getPlatFee() != null ? platFee.getPlatFee().toPlainString() : "0");
            try {
                if (bizType.equals(1)) {
                    command.setTradeType("03");
                } else {
                    command.setTradeType("04");
                }
                if ("offline".equalsIgnoreCase(order.getPayType())) {
                    paymentCommandResult = this.paymentProvider.offlinePayPlatTransfer(command);
                }
                paymentCommandResult = this.paymentProvider.transfer(command);
            }
            catch (Exception exception) {
                logger.error("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8\uff0c\u51bb\u7ed3\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo(), (Object)exception);
                throw exception;
            }
        } else {
            logger.info("\u8ba2\u5355\u91d1\u989d\u5c0f\u7b49\u4e8e0\uff0c\u4f17\u90a6\u5546\u57ce\u4e0d\u8d70\u652f\u4ed8\u6d41\u7a0b\uff0c\u76f4\u63a5\u6210\u529f");
        }
        PaymentCommandResult finalPaymentCommandResult = paymentCommandResult;
        this.transactionTemplate.execute(e -> {
            if (finalPaymentCommandResult != null) {
                this.paymentProvider.done(DonePaymentCommand.create((String)finalPaymentCommandResult.getReqSeqId(), (String)finalPaymentCommandResult.getHfSeqId(), (boolean)false), finalPaymentCommandResult.getPaymentTradeSnapshots());
            }
            order.setPaid(Boolean.valueOf(true));
            order.setBizType(bizType);
            order.setPayTime((Date)DateUtil.date());
            if (order.getStatus().intValue() == OrderConstants.ORDER_STATUS_WAIT_PAY.intValue()) {
                order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            }
            this.orderService.updateById((Object)order);
            return true;
        });
        if (!"offline".equalsIgnoreCase(order.getPayType())) {
            logger.error("\u6267\u884c\u7ebf\u4e0b\u62c6\u5355\u64cd\u4f5c:orderNo={}; payType={}", (Object)order.getOrderNo(), (Object)order.getPayType());
            this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        }
        return true;
    }

    protected void donePaymentForOrder(Order order, Integer bizType) {
    }
}

