/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.payment.impls;

import cn.hutool.core.thread.ThreadUtil;
import com.zbkj.bcx.cores.components.JsonProvider;
import com.zbkj.bcx.cores.constants.PaymentConstant;
import com.zbkj.bcx.cores.exceptions.BadCoreException;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.payment.impls.PaymentProviderAbstract;
import com.zbkj.payment.mappers.PaymentTransactionMapper;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.service.CommonWalletService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.wangshang.api.WSApiRequest;
import com.zbkj.service.wangshang.constants.WSBusiCode;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

@Component(value="WANGSHANG")
public class PaymentProviderImpl_WS
extends PaymentProviderAbstract {
    private static final Logger logger = LoggerFactory.getLogger(PaymentProviderImpl_WS.class);

    public PaymentProviderImpl_WS(RedisUtil redisUtil, RedissonClient redissonClient, SystemConfigService systemConfigService, HuifuWalletAccountDao huifuWalletAccountDao, HuifuWalletTradeDao huifuWalletTradeDao, TransactionTemplate transactionTemplate, CommonWalletService commonWalletService, JsonProvider jsonProvider, PaymentTransactionMapper transactionMapper) {
        super(redisUtil, redissonClient, systemConfigService, huifuWalletAccountDao, huifuWalletTradeDao, transactionTemplate, commonWalletService, jsonProvider, transactionMapper);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Map<String, Object> doYePayTransfer(Map<String, Object> p) {
        try {
            WSBusiCode wSBusiCode = WSBusiCode.YEPAY;
            Map response = WSApiRequest.api((WSBusiCode)wSBusiCode, p);
            this.getTransaction(String.valueOf(response.get("hfSeqId")), String.valueOf(response.get("reqSeqId")));
            return response;
        }
        catch (Exception e) {
            throw new CrmebWalletException(e.getMessage());
        }
    }

    public String getChannelName() {
        return PaymentChannel.WANGSHANG.getName();
    }

    public Map<String, Object> getTransaction(String hfSeqId, String reqSeqId) {
        if (StringUtils.isEmpty((Object)hfSeqId) || StringUtils.isEmpty((Object)reqSeqId)) {
            throw new BadCoreException(String.format("\u53c2\u6570(hfSeqId=%s;reqSeqId=%s)\u5f02\u5e38", hfSeqId, reqSeqId));
        }
        HashMap<String, String> rqStatus = new HashMap<String, String>();
        rqStatus.put("hfSeqId", hfSeqId);
        rqStatus.put("reqSeqId", reqSeqId);
        Map dkQueryResponse = null;
        try {
            String transStat;
            while ("DEALING".equals(transStat = String.valueOf((dkQueryResponse = WSApiRequest.api((WSBusiCode)WSBusiCode.DKQUERY, rqStatus)).get(PaymentConstant.TRANS_STAT)).toUpperCase())) {
                ThreadUtil.sleep((Number)100);
            }
            if ("FAIL".equals(transStat)) {
                throw new CrmebWalletException(String.format("\u652f\u4ed8\u5f02\u5e38:%s", dkQueryResponse.get("error_desc")));
            }
            return dkQueryResponse;
        }
        catch (Exception ex) {
            throw new BadCoreException(String.format("\u652f\u4ed8\u72b6\u6001(hfseqId=%s;reqSeqId=%s)\u67e5\u8be2\u5f02\u5e38", hfSeqId, reqSeqId), ex);
        }
    }
}

