/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwk.Jwk;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.security.PublicKey;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class AppleUtil {
    private static final Logger logger = LoggerFactory.getLogger(AppleUtil.class);

    private static JSONArray getAuthKeys() {
        RestTemplate restTemplate = new RestTemplate();
        String url = "https://appleid.apple.com/auth/keys";
        JSONObject json = (JSONObject)restTemplate.getForObject(url, JSONObject.class, new Object[0]);
        if (ObjectUtil.isNull((Object)json)) {
            logger.error("\u83b7\u53d6\u82f9\u679c\u7684\u516c\u94a5\u5931\u8d25");
        }
        JSONArray arr = json.getJSONArray("keys");
        return arr;
    }

    public static Boolean verify(String jwt) throws Exception {
        JSONArray arr = AppleUtil.getAuthKeys();
        if (arr == null) {
            return false;
        }
        JSONObject authKey = null;
        authKey = JSONObject.parseObject((String)arr.getString(0));
        if (AppleUtil.verifyExc(jwt, authKey).booleanValue()) {
            return true;
        }
        authKey = JSONObject.parseObject((String)arr.getString(1));
        return AppleUtil.verifyExc(jwt, authKey);
    }

    public static Boolean verifyExc(String jwt, JSONObject authKey) throws Exception {
        Jwk jwa = Jwk.fromValues((Map)authKey);
        PublicKey publicKey = jwa.getPublicKey();
        String aud = "";
        String sub = "";
        if (jwt.split("\\.").length > 1) {
            String claim = new String(Base64.decodeBase64((String)jwt.split("\\.")[1]));
            aud = JSONObject.parseObject((String)claim).get((Object)"aud").toString();
            sub = JSONObject.parseObject((String)claim).get((Object)"sub").toString();
        }
        JwtParser jwtParser = Jwts.parser().setSigningKey((Key)publicKey);
        jwtParser.requireIssuer("https://appleid.apple.com");
        jwtParser.requireAudience(aud);
        jwtParser.requireSubject(sub);
        try {
            Jws claim = jwtParser.parseClaimsJws(jwt);
            if (claim != null && ((Claims)claim.getBody()).containsKey((Object)"auth_time")) {
                System.out.println(claim);
                return true;
            }
            return false;
        }
        catch (ExpiredJwtException e) {
            logger.error("apple identityToken expired", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("apple identityToken illegal", (Throwable)e);
            return false;
        }
    }

    public static JSONObject parserIdentityToken(String identityToken) {
        String[] arr = identityToken.split("\\.");
        String decode = new String(Base64.decodeBase64((String)arr[1]));
        String substring = decode.substring(0, decode.indexOf("}") + 1);
        return JSON.parseObject((String)substring);
    }
}

