/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.exception.CrmebException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class UploadWeChatMediaUtil {
    public static JSONObject uploadFile(String url, InputStream file, String fileName) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpPost httppost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(200000).setSocketTimeout(200000).build();
            httppost.setConfig(requestConfig);
            HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", UploadWeChatMediaUtil.input2byte(file), ContentType.DEFAULT_BINARY, fileName).build();
            httppost.setEntity(reqEntity);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                System.out.println(response.getStatusLine());
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    String responseEntityStr = EntityUtils.toString((HttpEntity)response.getEntity());
                    JSONObject jSONObject = JSONObject.parseObject((String)responseEntityStr);
                    return jSONObject;
                }
                EntityUtils.consume((HttpEntity)resEntity);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CrmebException(e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                throw new CrmebException(e.getMessage());
            }
        }
        return null;
    }

    private static byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        return swapStream.toByteArray();
    }
}

