/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.WXPayXmlUtil;
import com.zbkj.common.utils.XmlUtil;
import com.zbkj.common.vo.CreateOrderRequestVo;
import com.zbkj.common.vo.WxRefundVo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.codec.digest.DigestUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WxPayUtil {
    public static HashMap<String, Object> processResponseXml(String xmlStr) throws Exception {
        String RETURN_CODE = "return_code";
        HashMap<String, Object> respData = XmlUtil.xmlToMap(xmlStr);
        if (!respData.containsKey(RETURN_CODE)) {
            throw new CrmebException(String.format("No `return_code` in XML: %s", xmlStr));
        }
        String return_code = (String)respData.get(RETURN_CODE);
        if (return_code.equals("FAIL")) {
            return respData;
        }
        if (return_code.equals("SUCCESS")) {
            return respData;
        }
        throw new CrmebException(String.format("return_code value %s is invalid in XML: %s", return_code, xmlStr));
    }

    public static String getNonceStr() {
        return DigestUtils.md5Hex((String)(CrmebUtil.getUuid() + CrmebUtil.randomCount(111111, 666666)));
    }

    public static String getSign(CreateOrderRequestVo vo, String signKey) {
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo), Map.class);
        Set keySet = map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || !ObjectUtil.isNotNull(map.get(k))) continue;
            sb.append((String)k).append("=").append(map.get(k)).append("&");
        }
        sb.append("key=").append(signKey);
        String sign = SecureUtil.md5((String)sb.toString()).toUpperCase();
        System.out.println("sign ========== " + sign);
        return sign;
    }

    public static String getSign(WxRefundVo wxRefundVo, String signKey) {
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)wxRefundVo), Map.class);
        Set keySet = map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || !ObjectUtil.isNotNull(map.get(k))) continue;
            sb.append((String)k).append("=").append(map.get(k)).append("&");
        }
        sb.append("key=").append(signKey);
        String sign = SecureUtil.md5((String)sb.toString()).toUpperCase();
        System.out.println("sign ========== " + sign);
        return sign;
    }

    public static String getSign(Map<String, String> map, String signKey) {
        Set<String> keySet = map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || !StrUtil.isNotBlank((CharSequence)map.get(k)) || map.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(map.get(k).trim()).append("&");
        }
        sb.append("key=").append(signKey);
        String sign = SecureUtil.md5((String)sb.toString()).toUpperCase();
        System.out.println("sign ========== " + sign);
        return sign;
    }

    public static String getSignObject(Map<String, Object> map, String signKey) {
        Set<String> keySet = map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || !ObjectUtil.isNotNull((Object)map.get(k))) continue;
            sb.append((String)k).append("=").append(map.get(k)).append("&");
        }
        sb.append("key=").append(signKey);
        String sign = SecureUtil.md5((String)sb.toString()).toUpperCase();
        System.out.println("sign ========== " + sign);
        return sign;
    }

    public static Long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static Map<String, String> xmlToMap(String strXML) throws Exception {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            DocumentBuilder documentBuilder = WXPayXmlUtil.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes(StandardCharsets.UTF_8));
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (Exception ex) {
            System.out.println(StrUtil.format((CharSequence)"Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object[])new Object[]{ex.getMessage(), strXML}));
            throw ex;
        }
    }
}

