/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.vo;

import cn.hutool.core.collection.CollUtil;
import com.zbkj.common.vo.MenuCheckVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class MenuCheckTree {
    private List<MenuCheckVo> menuList = new ArrayList<MenuCheckVo>();

    public MenuCheckTree(List<MenuCheckVo> menuList) {
        this.menuList = menuList;
    }

    public List<MenuCheckVo> buildTree() {
        ArrayList<MenuCheckVo> treeMenus = new ArrayList<MenuCheckVo>();
        for (MenuCheckVo menuNode : this.getRootNode()) {
            menuNode = this.buildChildTree(menuNode);
            treeMenus.add(menuNode);
        }
        return this.sortList(treeMenus);
    }

    private List<MenuCheckVo> sortList(List<MenuCheckVo> treeMenus) {
        treeMenus = treeMenus.stream().sorted(Comparator.comparing(MenuCheckVo::getSort).reversed()).collect(Collectors.toList());
        treeMenus.forEach(e -> {
            if (CollUtil.isNotEmpty(e.getChildList())) {
                e.setChildList(this.sortList(e.getChildList()));
            }
        });
        return treeMenus;
    }

    private MenuCheckVo buildChildTree(MenuCheckVo pNode) {
        ArrayList<MenuCheckVo> childMenus = new ArrayList<MenuCheckVo>();
        for (MenuCheckVo menuNode : this.menuList) {
            if (!menuNode.getPid().equals(pNode.getId())) continue;
            childMenus.add(this.buildChildTree(menuNode));
        }
        pNode.setChildList(childMenus);
        return pNode;
    }

    private List<MenuCheckVo> getRootNode() {
        ArrayList<MenuCheckVo> rootMenuLists = new ArrayList<MenuCheckVo>();
        for (MenuCheckVo menuNode : this.menuList) {
            if (!menuNode.getPid().equals(0)) continue;
            rootMenuLists.add(menuNode);
        }
        return rootMenuLists;
    }
}

