/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.ProtocolWithholdRefundResultNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.ProtocolWithholdRefundResultNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ProtocolWithholdRefundResultNotify")
public class ProtocolWithholdRefundResultNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolWithholdRefundResultNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > \u534f\u8bae\u4ee3\u6263\u9000\u6b3e\u7ed3\u679c\u901a\u77e5\uff1aant.mybank.bkcloudfunds.protocol.withhold.refund.result.notify");
        logger.info("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        ProtocolWithholdRefundResultNotifyRequest notifyRequest = XmlConverter.getInstance().toResponse(context, ProtocolWithholdRefundResultNotifyRequest.class);
        RequestHead head = notifyRequest.getRefundResultNotify().getRequestHead();
        boolean flag = false;
        try {
            flag = this.saveNotify(notifyRequest.getRefundResultNotify().getModel());
        }
        catch (Exception e) {
            logger.error("========= > \u534f\u8bae\u6388\u6743\u4ee3\u6263\u901a\u77e5\u7ed3\u679c\uff1aant.mybank.bkcloudfunds.protocol.withhold.result.notify:" + e.getMessage());
        }
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u534f\u8bae\u4ee3\u6263\u9000\u6b3e\u7ed3\u679c\u901a\u77e5\uff1aant.mybank.bkcloudfunds.protocol.withhold.refund.result.notify", "1", context, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(ProtocolWithholdRefundResultNotifyModel model) {
        model.getRefundOrderNo();
        model.getRefundAmount();
        model.getRefundFinishDate();
        model.getRelateOrderNo();
        model.getChannelRefundOrderNo();
        model.getStatus();
        model.getParticipantActualRefundAmount();
        model.getOutRefundNo();
        model.getRelateTransNo();
        model.getErrorDesc();
        return true;
    }
}

