/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.enums.PayComponentCatStatusEnum;
import com.zbkj.common.model.wechat.video.PayComponentShopBrand;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditBrandRequestItemDataVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditBrandRequestItemVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditBrandRequestVo;
import com.zbkj.common.vo.wxvedioshop.audit.ShopAuditBrandResponseVo;
import com.zbkj.service.dao.PayComponentShopBrandDao;
import com.zbkj.service.service.PayComponentShopBrandService;
import com.zbkj.service.service.WechatVideoBeforeService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayComponentShopBrandServiceImpl
extends ServiceImpl<PayComponentShopBrandDao, PayComponentShopBrand>
implements PayComponentShopBrandService {
    @Resource
    private PayComponentShopBrandDao dao;
    @Autowired
    private WechatVideoBeforeService wechatVideoBeforeService;

    @Override
    public String auditBrand(ShopAuditBrandRequestVo request) {
        ShopAuditBrandResponseVo brandResponseVo = this.wechatVideoBeforeService.shopAuditBrand(request);
        PayComponentShopBrand shopBrand = new PayComponentShopBrand();
        ShopAuditBrandRequestItemVo auditReq = request.getAuditReq();
        ShopAuditBrandRequestItemDataVo brandInfo = auditReq.getBrandInfo();
        BeanUtils.copyProperties((Object)brandInfo, (Object)shopBrand);
        shopBrand.setAuditId(brandResponseVo.getAuditId());
        shopBrand.setLicense(auditReq.getLicense());
        shopBrand.setStatus(PayComponentCatStatusEnum.INIT.getCode());
        shopBrand.setCreateTime((Date)DateUtil.date());
        this.save(shopBrand);
        return brandResponseVo.getAuditId();
    }

    @Override
    public PayComponentShopBrand getByAuditId(String auditId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentShopBrand::getAuditId, (Object)auditId);
        lqw.orderByDesc(PayComponentShopBrand::getId);
        lqw.last(" limit 1");
        return (PayComponentShopBrand)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public PageInfo<PayComponentShopBrand> findList(PageParamRequest pageParamRequest, Integer status) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)status)) {
            lqw.eq(PayComponentShopBrand::getStatus, (Object)status);
        }
        lqw.orderByDesc(PayComponentShopBrand::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public List<PayComponentShopBrand> getUsableList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{PayComponentShopBrand::getId, PayComponentShopBrand::getBrandId, PayComponentShopBrand::getBrandWording});
        lqw.eq(PayComponentShopBrand::getStatus, (Object)1);
        lqw.orderByDesc(PayComponentShopBrand::getId);
        return this.dao.selectList((Wrapper)lqw);
    }
}

