/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.service.dao.OrderDetailDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrderDetailServiceImpl
extends ServiceImpl<OrderDetailDao, OrderDetail>
implements OrderDetailService {
    @Resource
    private OrderDetailDao dao;
    @Resource
    private MerchantService merchantService;

    @Override
    public List<OrderDetail> getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(OrderDetail::getOrderNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<OrderDetail> getBySourceId(String sourceId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(OrderDetail::getSourceId, (Object)sourceId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<OrderDetail> getNotBrokerageList() {
        return this.dao.selectNotBrokerageList();
    }

    @Override
    public PageInfo<OrderDetail> getReplyList(Integer userId, Boolean isReply, PageParamRequest pageRequest) {
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        List<OrderDetail> orderDetailList = this.dao.findReplyList(userId, isReply != false ? 1 : 0);
        return CommonPage.copyPageInfo((Page)page, orderDetailList);
    }

    @Override
    public Boolean takeDelivery(String orderNo) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(OrderDetail::getIsReceipt, (Object)true);
        wrapper.eq(OrderDetail::getOrderNo, (Object)orderNo);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<OrderDetail> findAfterSaleApplyList(Integer uid, String orderNo, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<OrderDetail> orderDetailList = this.dao.findAfterSaleApplyList(uid, orderNo);
        return CommonPage.copyPageInfo((Page)page, orderDetailList);
    }

    @Override
    public Integer getSalesNumByDateAndProductId(String date, Integer proId) {
        return this.dao.getSalesNumByDateAndProductId(date, proId);
    }

    @Override
    public BigDecimal getSalesByDateAndProductId(String date, Integer proId) {
        return this.dao.getSalesByDateAndProductId(date, proId);
    }

    @Override
    public List<OrderDetail> getShipmentByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{OrderDetail::getId, OrderDetail::getProductName, OrderDetail::getImage, OrderDetail::getSku, OrderDetail::getPayNum, OrderDetail::getDeliveryNum, OrderDetail::getRefundNum});
        lqw.eq(OrderDetail::getOrderNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getAwaitReplyCount(Integer userId) {
        return this.dao.getAwaitReplyCount(userId);
    }

    @Override
    public Boolean isPurchased(Integer proId, Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{OrderDetail::getId});
        lqw.eq(OrderDetail::getProductId, (Object)proId);
        lqw.eq(OrderDetail::getUid, (Object)userId);
        lqw.gt(OrderDetail::getMerId, (Object)0);
        lqw.eq(OrderDetail::getIsReceipt, (Object)1);
        lqw.last("limit 1");
        OrderDetail orderDetail = (OrderDetail)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)orderDetail) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public PageInfo<OrderDetail> findPurchasedList(Integer userId, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{OrderDetail::getId, OrderDetail::getProductId});
        lqw.eq(OrderDetail::getUid, (Object)userId);
        lqw.gt(OrderDetail::getMerId, (Object)0);
        lqw.eq(OrderDetail::getIsReceipt, (Object)1);
        lqw.groupBy(OrderDetail::getProductId);
        lqw.orderByDesc(OrderDetail::getId);
        List detailList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)detailList);
    }

    @Override
    public Map<String, List<OrderDetail>> getMapByOrderNoList(List<String> orderNoList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(OrderDetail::getOrderNo, orderNoList);
        List detailList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)detailList)) {
            return null;
        }
        List<Integer> merIdList = detailList.stream().map(OrderDetail::getMerId).collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = this.merchantService.getMapByIdList(merIdList);
        detailList.forEach(o -> o.setMerName(((Merchant)merchantMap.get(o.getMerId())).getName()));
        return detailList.stream().collect(Collectors.groupingBy(OrderDetail::getOrderNo));
    }

    @Override
    public List<OrderDetail> getByProductIdList(List<Integer> productIds) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(OrderDetail::getProductId, productIds);
        return this.dao.selectList((Wrapper)lqw);
    }
}

