/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxUserBank;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxUserAddBankCardRequest;
import com.zbkj.common.request.BcxUserEditBankCardRequest;
import com.zbkj.common.request.BcxUserOperateBankCardRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.IdGeneratorSnowflake;
import com.zbkj.service.dao.BcxUserBankDao;
import com.zbkj.service.service.BcxUserBankService;
import com.zbkj.service.service.UserService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BcxUserBankServiceImpl
extends ServiceImpl<BcxUserBankDao, BcxUserBank>
implements BcxUserBankService {
    @Resource
    private BcxUserBankDao dao;
    @Autowired
    private UserService userService;
    @Autowired
    private IdGeneratorSnowflake snowflake;

    @Override
    public PageInfo<BcxUserBank> getPage(PageParamRequest pageParamRequest) {
        Integer userId = this.userService.getUserId();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxUserBank::getUid, (Object)userId);
        lqw.orderByAsc(BcxUserBank::getCreateTime);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List bankList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)bankList);
    }

    @Override
    @Transactional
    public Boolean bindBankCard(BcxUserAddBankCardRequest request) {
        Integer userId = this.userService.getUserId();
        BcxUserBank exist = this.getByBankCardNo(request.getBankCardNo());
        if (exist != null) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8be5\u94f6\u884c\u5361\u53f7\u5df2\u7ecf\u88ab\u7ed1\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165"));
        }
        BcxUserBank userBank = new BcxUserBank();
        BeanUtils.copyProperties((Object)request, (Object)userBank);
        userBank.setId(Long.valueOf(this.snowflake.snowflakeId()));
        userBank.setUid(userId);
        userBank.setStatus(Integer.valueOf(1));
        userBank.setCreateTime(new Date());
        userBank.setUpdateTime(new Date());
        this.checkDefault(userId, userBank);
        this.save(userBank);
        return true;
    }

    @Override
    @Transactional
    public Boolean editBankCard(BcxUserEditBankCardRequest request) {
        Integer userId = this.userService.getUserId();
        BcxUserBank exist = this.getByBankCardNo(request.getBankCardNo());
        if (exist != null && exist.getId().longValue() != request.getId().longValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8be5\u94f6\u884c\u5361\u53f7\u5df2\u7ecf\u88ab\u7ed1\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165"));
        }
        BcxUserBank userBank = (BcxUserBank)this.getById(request.getId());
        if (userBank == null) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8981\u4fee\u6539\u7684\u94f6\u884c\u5361\u4e0d\u5b58\u5728"));
        }
        if (userBank.getUid().intValue() != userId.intValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u53ea\u80fd\u4fee\u6539\u81ea\u5df1\u7684\u94f6\u884c\u5361"));
        }
        BeanUtils.copyProperties((Object)request, (Object)userBank);
        userBank.setUpdateTime(new Date());
        this.checkDefault(userId, userBank);
        this.updateById(userBank);
        return true;
    }

    @Override
    @Transactional
    public Boolean setBankCardDefault(BcxUserOperateBankCardRequest request) {
        Integer userId = this.userService.getUserId();
        BcxUserBank userBank = (BcxUserBank)this.getById(request.getId());
        if (userBank == null) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8981\u8bbe\u7f6e\u7684\u94f6\u884c\u5361\u4e0d\u5b58\u5728"));
        }
        if (userBank.getUid().intValue() != userId.intValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u53ea\u80fd\u8bbe\u7f6e\u81ea\u5df1\u7684\u94f6\u884c\u5361"));
        }
        userBank.setIsDefault(Integer.valueOf(1));
        userBank.setUpdateTime(new Date());
        this.checkDefault(userId, userBank);
        this.updateById(userBank);
        return true;
    }

    @Override
    @Transactional
    public Boolean unbindBankCard(BcxUserOperateBankCardRequest request) {
        Optional<BcxUserBank> bcxUserBankOptional;
        List<BcxUserBank> bankList;
        Integer userId = this.userService.getUserId();
        BcxUserBank userBank = (BcxUserBank)this.getById(request.getId());
        if (userBank == null) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u8981\u5220\u9664\u7684\u94f6\u884c\u5361\u4e0d\u5b58\u5728"));
        }
        if (userBank.getUid().intValue() != userId.intValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7684\u94f6\u884c\u5361"));
        }
        if (userBank.getIsDefault() == 1 && CollectionUtil.isNotEmpty(bankList = this.getByUid(userId)) && (bcxUserBankOptional = bankList.stream().filter(bank -> bank.getId().longValue() != userBank.getId().longValue()).findFirst()).isPresent()) {
            BcxUserBank bcxUserBank = bcxUserBankOptional.get();
            bcxUserBank.setIsDefault(Integer.valueOf(1));
            bcxUserBank.setUpdateTime(new Date());
            this.updateById(bcxUserBank);
        }
        this.removeById(userBank.getId());
        return true;
    }

    private BcxUserBank getByBankCardNo(String bankCardNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxUserBank::getBankCardNo, (Object)bankCardNo);
        return (BcxUserBank)this.dao.selectOne((Wrapper)lqw);
    }

    private List<BcxUserBank> getByUid(Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxUserBank::getUid, (Object)uid);
        return this.dao.selectList((Wrapper)lqw);
    }

    private void checkDefault(Integer userId, BcxUserBank userBank) {
        List<BcxUserBank> bankList = this.getByUid(userId);
        if (userBank.getIsDefault() == 1) {
            if (CollectionUtil.isNotEmpty(bankList)) {
                for (BcxUserBank bcxUserBank : bankList) {
                    bcxUserBank.setIsDefault(Integer.valueOf(0));
                }
            }
            this.updateBatchById(bankList);
        } else if (CollectionUtil.isEmpty(bankList)) {
            userBank.setIsDefault(Integer.valueOf(1));
        }
    }
}

