/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.SystemFormTemp;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemFormCheckRequest;
import com.zbkj.common.request.SystemFormItemCheckRequest;
import com.zbkj.common.request.SystemFormTempRequest;
import com.zbkj.common.request.SystemFormTempSearchRequest;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemFormResultCode;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.SystemConfigFormItemConfigRegListVo;
import com.zbkj.common.vo.SystemConfigFormItemVo;
import com.zbkj.common.vo.SystemConfigFormVo;
import com.zbkj.service.dao.SystemFormTempDao;
import com.zbkj.service.service.SystemFormTempService;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SystemFormTempServiceImpl
extends ServiceImpl<SystemFormTempDao, SystemFormTemp>
implements SystemFormTempService {
    @Resource
    private SystemFormTempDao dao;

    @Override
    public List<SystemFormTemp> getList(SystemFormTempSearchRequest request, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(SystemFormTemp::getId, (Object)keywords)).or()).like(SystemFormTemp::getName, (Object)keywords)).or()).like(SystemFormTemp::getInfo, (Object)keywords);
        }
        lambdaQueryWrapper.orderByDesc(SystemFormTemp::getId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public void checkForm(SystemFormCheckRequest systemFormCheckRequest) {
        SystemConfigFormVo systemConfigFormVo;
        HashMap<String, String> map = new HashMap<String, String>();
        for (SystemFormItemCheckRequest systemFormItemCheckRequest : systemFormCheckRequest.getFields()) {
            map.put(systemFormItemCheckRequest.getName(), systemFormItemCheckRequest.getValue());
        }
        SystemFormTemp formTemp = (SystemFormTemp)this.getById(systemFormCheckRequest.getId());
        try {
            systemConfigFormVo = (SystemConfigFormVo)JSONObject.parseObject((String)formTemp.getContent(), SystemConfigFormVo.class);
        }
        catch (Exception e) {
            throw new CrmebException("\u6a21\u677f\u8868\u5355 \u3010" + formTemp.getName() + "\u3011 \u7684\u5185\u5bb9\u4e0d\u662f\u6b63\u786e\u7684JSON\u683c\u5f0f\uff01");
        }
        for (String item : systemConfigFormVo.getFields()) {
            SystemConfigFormItemVo systemConfigFormItemVo = (SystemConfigFormItemVo)JSONObject.parseObject((String)item, SystemConfigFormItemVo.class);
            String model = systemConfigFormItemVo.get__vModel__();
            if (systemConfigFormItemVo.get__config__().getRequired().booleanValue() && ((String)map.get(model)).equals("")) {
                throw new CrmebException(systemConfigFormItemVo.get__config__().getLabel() + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.checkRule(systemConfigFormItemVo.get__config__().getRegList(), (String)map.get(model), systemConfigFormItemVo.get__config__().getLabel());
        }
    }

    @Override
    public Boolean add(SystemFormTempRequest systemFormTempRequest) {
        try {
            JSONObject.parseObject((String)systemFormTempRequest.getContent(), SystemConfigFormVo.class);
        }
        catch (Exception e) {
            throw new CrmebException(SystemFormResultCode.FORM_TEMP_PARAMETER_ERROR.setMsgParams(new Object[]{systemFormTempRequest.getName()}));
        }
        SystemFormTemp temp = this.getOneByName(systemFormTempRequest.getName());
        if (ObjectUtil.isNotNull((Object)temp)) {
            throw new CrmebException((IResultEnum)SystemFormResultCode.FORM_TEMP_NAME_REPEAT);
        }
        SystemFormTemp systemFormTemp = new SystemFormTemp();
        BeanUtils.copyProperties((Object)systemFormTempRequest, (Object)systemFormTemp);
        return this.save(systemFormTemp);
    }

    @Override
    public Boolean edit(Integer id, SystemFormTempRequest systemFormTempRequest) {
        try {
            JSONObject.parseObject((String)systemFormTempRequest.getContent(), SystemConfigFormVo.class);
        }
        catch (Exception e) {
            throw new CrmebException("\u6a21\u677f\u8868\u5355 \u3010" + systemFormTempRequest.getName() + "\u3011 \u7684\u5185\u5bb9\u4e0d\u662f\u6b63\u786e\u7684JSON\u683c\u5f0f\uff01");
        }
        SystemFormTemp temp = this.getOneByName(systemFormTempRequest.getName());
        if (ObjectUtil.isNotNull((Object)temp) && !temp.getId().equals(id)) {
            throw new CrmebException((IResultEnum)SystemFormResultCode.FORM_TEMP_NAME_REPEAT);
        }
        SystemFormTemp systemFormTemp = new SystemFormTemp();
        BeanUtils.copyProperties((Object)systemFormTempRequest, (Object)systemFormTemp);
        systemFormTemp.setId(id);
        return this.updateById(systemFormTemp);
    }

    @Override
    public SystemFormTemp getOneByName(String name) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemFormTemp::getName, (Object)URLUtil.decode((String)name));
        lqw.last(" limit 1");
        SystemFormTemp systemFormTemp = (SystemFormTemp)this.dao.selectOne((Wrapper)lqw);
        return systemFormTemp;
    }

    private void checkRule(List<SystemConfigFormItemConfigRegListVo> regList, String value, String name) {
        if (regList.size() > 0) {
            for (SystemConfigFormItemConfigRegListVo systemConfigFormItemConfigRegListVo : regList) {
                if (ValidateFormUtil.regular((String)value, (String)name, (String)systemConfigFormItemConfigRegListVo.getPattern())) continue;
                throw new CrmebException(systemConfigFormItemConfigRegListVo.getMessage());
            }
        }
    }
}

