/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Joiner;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.live.WechatLiveAssistant;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.dao.wechat.live.WechatLiveAssistantDao;
import com.zbkj.service.service.WechatLiveAssistantService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class WechatLiveAssistantServiceImpl
extends ServiceImpl<WechatLiveAssistantDao, WechatLiveAssistant>
implements WechatLiveAssistantService {
    private static final Logger logger = LoggerFactory.getLogger(WechatLiveAssistantServiceImpl.class);
    @Resource
    private WechatLiveAssistantDao wechatLiveAssistantDao;

    @Override
    public List<WechatLiveAssistant> getList(String keywords, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LoginUserVo currentUser = SecurityUtil.getLoginUserVo();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)keywords)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.like(WechatLiveAssistant::getWechat, (Object)URLUtil.decode((String)keywords))).or()).like(WechatLiveAssistant::getWechatNickname, (Object)URLUtil.decode((String)keywords));
        }
        lambdaQueryWrapper.eq(WechatLiveAssistant::getMerId, (Object)currentUser.getUser().getMerId());
        lambdaQueryWrapper.orderByDesc(WechatLiveAssistant::getCreateTime);
        return this.wechatLiveAssistantDao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean saveUnique(WechatLiveAssistant wechatLiveAssistant) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(WechatLiveAssistant::getWechat, (Object)wechatLiveAssistant.getWechat());
        List wechatLiveAssistants = this.wechatLiveAssistantDao.selectList((Wrapper)lambdaQueryWrapper);
        if (wechatLiveAssistants.size() > 0) {
            throw new CrmebException("\u5fae\u4fe1\u76f4\u64ad\u5c0f\u52a9\u624b\u5df2\u7ecf\u5b58\u5728:" + wechatLiveAssistant.getWechat());
        }
        wechatLiveAssistant.setMerId(SecurityUtil.getLoginUserVo().getUser().getMerId());
        return this.wechatLiveAssistantDao.insert(wechatLiveAssistant) > 0;
    }

    @Override
    public List<WechatLiveAssistant> syncAssListUnique(List<WechatLiveAssistant> wechatLiveAssistant) {
        ArrayList<WechatLiveAssistant> resultList = new ArrayList<WechatLiveAssistant>();
        List currentAssWechatList = wechatLiveAssistant.stream().map(WechatLiveAssistant::getWechat).collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.in(WechatLiveAssistant::getWechat, new Object[]{Joiner.on((String)",").join(currentAssWechatList)});
        List currentExitAssList = this.wechatLiveAssistantDao.selectList((Wrapper)lambdaQueryWrapper);
        Collection intersection1 = CollectionUtils.intersection(wechatLiveAssistant, (Iterable)currentExitAssList);
        Collection intersection2 = CollectionUtils.disjunction(wechatLiveAssistant, (Iterable)currentExitAssList);
        logger.info("TEST:\u4ea4\u96c6:{}", (Object)JSON.toJSONString((Object)intersection1));
        logger.info("TEST:\u5dee\u96c6:{}", (Object)JSON.toJSONString((Object)intersection2));
        for (WechatLiveAssistant assistant : currentExitAssList) {
            List existAss = wechatLiveAssistant.stream().filter(ass -> ass.getWechat().equals(assistant.getWechat())).collect(Collectors.toList());
            if (existAss.size() == 0) {
                logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u76f4\u64ad\u95f4 - \u540c\u6b65\u5c0f\u52a9\u624b \u66f4\u65b0\u65f6\u5b58\u5728\u6f0f\u7f51\u4e4b\u9c7c:{}:\u672c\u5730\u6ca1\u6709\u627e\u5230", (Object)JSON.toJSONString((Object)assistant));
                break;
            }
            WechatLiveAssistant currentAssForUpdate = (WechatLiveAssistant)existAss.get(0);
            BeanUtils.copyProperties((Object)currentAssForUpdate, (Object)assistant);
            assistant.setId(currentAssForUpdate.getId());
        }
        logger.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u540c\u6b65\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b - \u66f4\u65b0\u6570\u636e\u662f:{}", (Object)JSON.toJSONString((Object)currentExitAssList));
        boolean assBatchUpdateResult = this.updateBatchById(currentExitAssList);
        logger.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u540c\u6b65\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b - \u7ed3\u679c:{}:\u5c0f\u52a9\u624b\u6279\u91cf\u66f4\u65b0\u7ed3\u675f", (Object)assBatchUpdateResult);
        resultList.addAll(currentExitAssList);
        ArrayList<WechatLiveAssistant> wechatLiveAssistantListForInsert = new ArrayList<WechatLiveAssistant>();
        for (WechatLiveAssistant assistant : wechatLiveAssistant) {
            List notExistAss = currentExitAssList.stream().filter(ass -> !ass.getWechat().equals(assistant.getWechat())).collect(Collectors.toList());
            if (notExistAss.size() <= 0) continue;
            WechatLiveAssistant currentASS = (WechatLiveAssistant)notExistAss.get(0);
            logger.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u76f4\u64ad\u95f4 - \u6709\u65b0\u589e\u5c0f\u52a9\u624b:{}", (Object)JSON.toJSONString((Object)currentASS));
            wechatLiveAssistantListForInsert.add(currentASS);
        }
        logger.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u76f4\u64ad\u95f4 - \u5f85\u65b0\u589e\u52a9\u624b:{}", (Object)JSON.toJSONString(wechatLiveAssistantListForInsert));
        resultList.addAll(wechatLiveAssistantListForInsert);
        return resultList;
    }
}

