package com.bcxin.auth.system.service.impl;

import java.util.List;

import com.bcxin.auth.common.utils.IdWorker;
import com.bcxin.auth.system.domain.SysRegion;
import com.bcxin.auth.system.mapper.SysRegionMapper;
import com.bcxin.auth.system.service.ISysRegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 地区Service业务层处理
 * 
 * @author bcxin
 * @date 2021-01-22
 */
@Service
public class SysRegionServiceImpl implements ISysRegionService
{
    @Autowired
    private SysRegionMapper sysRegionMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询地区
     * 
     * @param regionId 地区ID
     * @return 地区
     */
    @Override
    public SysRegion selectSysRegionById(Long regionId)
    {
        return sysRegionMapper.selectSysRegionById(regionId);
    }

    /**
     * 查询地区列表
     * 
     * @param sysRegion 地区
     * @return 地区
     */
    @Override
    public List<SysRegion> selectSysRegionList(SysRegion sysRegion)
    {
        return sysRegionMapper.selectSysRegionList(sysRegion);
    }

}
