package com.bcxin.auth.system.service;


import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.dto.datasync.DataSyncDto;

import java.util.List;


/**
 * 数据同步记录Service接口
 * 
 * @author lin
 * @date 2020-12-07
 */
public interface IDataSyncLogService {

    /****
     * 删除
     * @param dataSyncLog
     * @return
     */
    int delete(DataSyncLog dataSyncLog);

    /****
     * 保存
     * @param dataSyncLog
     * @return
     */
    int save(DataSyncLog dataSyncLog);

    /****
     * 选择性修改
     * @param dataSyncLog
     * @return
     */
    void updateSelective(DataSyncLog dataSyncLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
    DataSyncLog findById(Long id);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<DataSyncLog> findByBatchId(List<DataSyncLog> list);

    /**
     *
     * @param dataSyncLog
     */
    void callback(DataSyncLog dataSyncLog);

    void receive(DataSyncDto dataSyncDto) throws Exception;
}
