package com.bcxin.platform.web.controller.manage;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.domain.product.ProductCoupon;
import com.bcxin.platform.dto.product.ProductCouponDownloadDto;
import com.bcxin.platform.dto.product.ProductCouponDto;
import com.bcxin.platform.service.product.ProductCouponService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 产品优惠券Controller
 * 
 * @author lin
 * @date 2021-06-21
 */
@Controller
@RequestMapping("/manage/coupon")
public class ProductCouponController extends BaseController{

    private String prefix = "manage/coupon";

    @Autowired
    private ProductCouponService productCouponService;

    @RequiresPermissions("coupon:view")
    @GetMapping()
    public String coupon(){
        return prefix + "/coupon";
    }

    /**
     * 查询产品优惠券列表
     */
    @RequiresPermissions("coupon:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(ProductCouponDto productCoupon){
        startPage();
        List<ProductCouponDownloadDto> list = productCouponService.selectProductCouponList(productCoupon);
        return getDataTable(list);
    }

    /**
     * 导出产品优惠券列表
     */
    @RequiresPermissions("coupon:export")
    @Log(title = "产品优惠券", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    @ResponseBody
    public AjaxResult export(ProductCouponDto productCoupon){
        List<ProductCouponDownloadDto> list = productCouponService.selectProductCouponList(productCoupon);
        ExcelUtil<ProductCouponDownloadDto> util = new ExcelUtil<ProductCouponDownloadDto>(ProductCouponDownloadDto.class);
        return util.exportExcel(list, "coupon");
    }

    /**
     * 新增产品优惠券
     */
    @GetMapping("/add")
    public String add(){
        return prefix + "/add";
    }

    /**
     * 新增保存产品优惠券
     */
    @RequiresPermissions("coupon:add")
    @Log(title = "产品优惠券", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    @ResponseBody
    public AjaxResult addSave(ProductCoupon productCoupon){
        return toAjax(productCouponService.updateProductCoupon(productCoupon));
    }

    /**
     * 删除产品优惠券
     */
    @RequiresPermissions("coupon:remove")
    @Log(title = "产品优惠券", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    @ResponseBody
    public AjaxResult remove(String ids){
        return toAjax(productCouponService.deleteProductCouponByIds(ids));
    }
}
