package com.bcxin.platform.web.controller.grant;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComBhGrantDetail;
import com.bcxin.platform.domain.grant.ComBhGrantInfo;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.grant.ComBhGrantInfoDTO;
import com.bcxin.platform.service.grant.ComBhGrantService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 企业渤海薪资发放
 * @author  llc
 * @date 2020-08-13
 */
@RestController
@RequestMapping("/com/bh/grant")
@Api(tags = { "" }, description = "企业薪资发放服务")
public class ComBhGrantController extends BaseController {

	@Autowired
	private ComBhGrantService comBhGrantService;


	/**
	 * 获取企业渤海薪资代发单列表
	 * @param dto
	 * @author llc
	 * @date 2020-08-13
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海薪资发放", title = "获取企业渤海薪资代发单列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "获取企业渤海薪资代发单列表", httpMethod = "POST", notes = "获取企业渤海薪资代发单列表", response = Result.class)
	@PostMapping(value = "page-com-bh-grant-info-list")
	public Result pageComBhGrantInfoList(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.pageComBhGrantInfoList(dto).setBack(getRequest());
	}


	/**
	 * 创建企业渤海薪资代发单
	 * @param comBhGrantInfo
	 * @author llc
	 * @date 2020-08-13
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业渤海薪资发放", title = "创建企业渤海薪资代发单", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "创建企业渤海薪资代发单", httpMethod = "POST", notes = "创建企业渤海薪资代发单", response = Result.class)
	@PostMapping(value = "save-com-bh-grant-info")
	public Result saveComBhGrantInfo(ComBhGrantInfo comBhGrantInfo) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.saveComBhGrantInfo(comBhGrantInfo).setBack(getRequest());
	}


	/**
	 * 根据id获取企业渤海薪资代发
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2020-08-13
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海薪资发放", title = "根据id获取企业渤海薪资代发", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "根据id获取企业渤海薪资代发", httpMethod = "POST", notes = "根据id获取企业渤海薪资代发", response = Result.class)
	@PostMapping(value = "get-com-bh-grant-info-by-id")
	public Result getComBhGrantInfoById(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.getComBhGrantInfoById(dto).setBack(getRequest());
	}


	/**
	 * 删除企业渤海薪资代发单
	 * @param dto
	 * @author llc
	 * @date 2020-08-13
	 */
	@Log(operation = Log.OPERA_TYPE_DEL, modle = "企业渤海薪资发放", title = "删除企业渤海薪资代发单", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "删除企业渤海薪资代发单", httpMethod = "POST", notes = "删除企业渤海薪资代发单", response = Result.class)
	@PostMapping(value = "delete-com-bh-grant-info")
	public Result deleteComBhGrantInfo(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.deleteComBhGrantInfo(dto).setBack(getRequest());
	}


	/**
	 * 获取企业渤海薪资发放明细
	 * @param dto
	 * @author llc
	 * @date 2020-08-13
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海薪资发放", title = "获取企业渤海薪资发放明细", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "获取企业渤海薪资发放明细", httpMethod = "POST", notes = "获取企业渤海薪资发放明细", response = Result.class)
	@PostMapping(value = "page-com-bh-grant-detail-list")
	public Result pageComBhGrantDetailList(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.pageComBhGrantDetailList(dto).setBack(getRequest());
	}

	/***
	 * 导出渤海薪资代发模板
	 * @param dto
	 * @author llc
	 * @date 2020-08-13
	 * @return
	 * @throws V5BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业薪资发放服务", title = "导出薪资代发模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-offline-grant-temp")
	@ApiOperation(value = "导出薪资代发模板", httpMethod = "GET", notes = "导出薪资代发模板", response = Result.class)
	public Result exportOfflineGrantTemp(ComBhGrantInfoDTO dto) throws V5BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.exportOfflineGrantTemp(dto,getResponse()).setBack(getRequest());
	}


	/***
	 * 导入渤海薪资代发模板
	 * @param dto
	 * @author llc
	 * @date 2020-08-13
	 * @return
	 * @throws V5BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业薪资发放服务", title = "导入薪资代发模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "import-offline-grant-temp")
	@ApiOperation(value = "导入薪资代发模板", httpMethod = "POST", notes = "导入薪资代发模板", response = Result.class)
	public Result importOfflineGrantTemp(@RequestParam("xfile") MultipartFile xfile, ComBhGrantInfoDTO dto) throws V5BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.importOfflineGrantTemp(xfile,dto).setBack(getRequest());
	}

	/***
	 * 导出渤海薪资银行卡代发模板
	 * @param dto
	 * @author llc
	 * @date 2020-12-04
	 * @return
	 * @throws V5BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业薪资发放服务", title = "导出渤海薪资银行卡代发模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "export-offline-bank-grant-temp")
	@ApiOperation(value = "导出渤海薪资银行卡代发模板", httpMethod = "GET", notes = "导出渤海薪资银行卡代发模板", response = Result.class)
	public Result exportOfflineBankGrantTemp(ComBhGrantInfoDTO dto) throws V5BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.exportOfflineBankGrantTemp(dto,getResponse()).setBack(getRequest());
	}

	/***
	 * 导入渤海薪资银行卡代发模板
	 * @param dto
	 * @author llc
	 * @date 2020-12-04
	 * @return
	 * @throws V5BusinessException
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业薪资发放服务", title = "导入渤海薪资银行卡代发模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "import-offline-bank-grant-temp")
	@ApiOperation(value = "导入渤海薪资银行卡代发模板", httpMethod = "POST", notes = "导入渤海薪资银行卡代发模板", response = Result.class)
	public Result importOfflineBankGrantTemp(@RequestParam("xfile") MultipartFile xfile, ComBhGrantInfoDTO dto) throws V5BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.importOfflineBankGrantTemp(xfile,dto).setBack(getRequest());
	}


	/**
	 * 删除企业渤海薪资代明细
	 * @param comBhGrantDetail
	 * @author llc
	 * @date 2020-08-17
	 */
	@Log(operation = Log.OPERA_TYPE_DEL, modle = "企业渤海薪资发放", title = "删除企业渤海薪资代明细", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "删除企业渤海薪资代明细", httpMethod = "POST", notes = "删除企业渤海薪资代明细", response = Result.class)
	@PostMapping(value = "delete-com-bh-grant-detail-by-id")
	public Result deleteComBhGrantDetailById(ComBhGrantDetail comBhGrantDetail) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.deleteComBhGrantDetailById(comBhGrantDetail).setBack(getRequest());
	}


	/**
	 * 提交发放申请
	 * @param dto
	 * @author llc
	 * @date 2020-08-17
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业渤海薪资发放", title = "提交发放申请", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "提交发放申请", httpMethod = "POST", notes = "提交发放申请", response = Result.class)
	@PostMapping(value = "commit-grant-apply")
	public Result commitGrantApply(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.commitGrantApply(dto).setBack(getRequest());
	}


	/**
	 * 提交发放申请（测试用）
	 * @param dto
	 * @author llc
	 * @date 2020-08-17
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业渤海薪资发放", title = "提交发放申请（测试用）", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "提交发放申请（测试用）", httpMethod = "POST", notes = "提交发放申请（测试用）", response = Result.class)
	@PostMapping(value = "commit-grant-apply-cs")
	public Result commitGrantApplyCs(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.commitGrantApplyCs(dto).setBack(getRequest());
	}


	/**
	 * 查询企业渤海发放操作记录列表
	 * @param dto
	 * @author llc
	 * @date 2020-08-17
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海薪资发放", title = "查询企业渤海发放操作记录列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "查询企业渤海发放操作记录列表", httpMethod = "POST", notes = "查询企业渤海发放操作记录列表", response = Result.class)
	@PostMapping(value = "get-bh-grant-oper-record-list")
	public Result getBhGrantOperRecordList(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.getBhGrantOperRecordList(dto).setBack(getRequest());
	}


	/**
	 * 获取渤海银行回单文件URL
	 * @param dto
	 * @author llc
	 * @date 2020-09-16
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海薪资发放", title = "获取渤海银行回单文件URL", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "获取渤海银行回单文件URL", httpMethod = "POST", notes = "获取渤海银行回单文件URL", response = Result.class)
	@PostMapping(value = "get-bh-bank-receipt-file-url")
	public Result getBhBankReceiptFileUrl(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.getBhBankReceiptFileUrl(dto).setBack(getRequest());
	}


	/**
	 * 同步渤海发放结果
	 * @param dto
	 * @author llc
	 * @date 2020-09-17
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业渤海薪资发放", title = "同步渤海发放结果", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "同步渤海发放结果", httpMethod = "POST", notes = "同步渤海发放结果", response = Result.class)
	@PostMapping(value = "sync-bh-grant-result")
	public Result syncBhGrantResult(ComBhGrantInfoDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhGrantService.syncBhGrantResult(dto).setBack(getRequest());
	}

}
