package com.bcxin.platform.web.controller.company;

import cn.hutool.json.JSONUtil;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.service.common.CommonServiceImpl;
import com.bcxin.platform.domain.system.SysRegion;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 省市县地区
 */
@RestController
@RequestMapping("/common/region")
@Api(description = "省市县地区查询") // tag中文会影响路径
public class RegionController extends BaseController {

	@Autowired
	private CommonServiceImpl commonService;

	@PostMapping("/get-region-by-id")
	@ApiOperation(value = "通过id获得地区属性", notes = "")
	public Result getRegionById(SysRegion sysRegion) {
		logger.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(sysRegion));
		return commonService.getRegionById(sysRegion).setBack(getRequest());
	}

	@PostMapping("/get-region-list")
	@ApiOperation(value = "通过id查询多个地区属性", notes = "")
	public Result getRegionList(String sysRegionList) {
		logger.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(sysRegionList));
		return commonService.getRegionList(sysRegionList).setBack(getRequest());
	}

	@PostMapping("/get-region-by-parent-id")
	@ApiOperation(value = "通过父节点获得所有子节点", notes = "")
	public Result getRegionByParentId(SysRegion sysRegion) {
		logger.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(sysRegion));
		return commonService.getRegionByParentId(sysRegion).setBack(getRequest());
	}

	@PostMapping("/get-region-by-level")
	@ApiOperation(value = "通过级别获得改级别所有节点", notes = "")
	public Result getRegionByLevel(SysRegion sysRegion) {
		logger.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(sysRegion));
		return commonService.getRegionByLevel(sysRegion).setBack(getRequest());
	}

	@PostMapping("/get-region-as-obj")
	@ApiOperation(value = "省市县数据对象", notes = "")
	public Result getRegionAsObj() {
		return commonService.getRegionAsObj().setBack(getRequest());
	}

	@PostMapping("/get-regions")
	@ApiOperation(value = "省市县数据", notes = "")
	public Object getRegions() {
		return commonService.getRegions().setBack(getRequest());
	}

	@PostMapping("/get-region-by-name")
	@ApiOperation(value = "根据地区名称获取地区对象", notes = "")
	public Result getRegionByName(String regionName) {
		return commonService.getRegionByName(regionName).setBack(getRequest());
	}

}
