package com.bcxin.platform.web.controller.company;

import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.company.ComBaseInfoDto;
import com.bcxin.platform.dto.company.ComDTO;
import com.bcxin.platform.service.company.ComBaseInfoService;
import com.bcxin.platform.util.log.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 企业基础信息Controller
 * 
 * @author lin
 * @date 2021-04-09
 */
@Controller
@RequestMapping("/company")
@Api(tags = { "" }, description = "V5-企业信息")
public class ComBaseInfoController extends BaseController{


    @Autowired
    private ComBaseInfoService comBaseInfoService;

    @Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业基本信息", title = "通过ID获得企业基本信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping("/get-com-base-info-by-id")
    @ApiOperation(value = "通过ID获得企业基本信息")
    @ResponseBody
    public Result getComBaseInfoById(ComDTO dto) {
        dto = comBaseInfoService.selectByID(dto);
        return Result.success(Result.SUCCESS_QUERY_MSG, dto).setBack(getRequest());
    }


    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业管理", title = "企业详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "get")
    @ApiOperation(value = "企业管理", httpMethod = "GET", notes = "获取企业详情", response = ComBaseInfoDto.class)
    @ResponseBody
    public Result get(ComBaseInfoDto comBaseInfoDto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        comBaseInfoDto.setComId(currentUser.getComId());
        return comBaseInfoService.getByPrimaryKey(comBaseInfoDto).setBack(getRequest());
    }


    /**
     * 查询企业基础信息列表
     */
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(ComBaseInfo comBaseInfo){
        startPage();
        List<ComBaseInfo> list = comBaseInfoService.selectComBaseInfoList(comBaseInfo);
        return getDataTable(list);
    }

    /**
     * 新增修改保存企业基础信息
     */
    @Log(operation = Log.OPERA_TYPE_UPDATE, modle = "企业管理", title = "新增修改保存企业信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "新增修改保存企业信息", httpMethod = "POST", notes = "新增修改保存企业信息")
    @PostMapping("/edit")
    @ResponseBody
    public AjaxResult editSave(ComBaseInfo comBaseInfo){
        return toAjax(comBaseInfoService.updateComBaseInfo(comBaseInfo));
    }

    /**
     * 删除企业基础信息
     */
    @Log(operation = Log.OPERA_TYPE_UPDATE, modle = "删除企业信息", title = "新增修改保存企业信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping( "/remove")
    @ApiOperation(value = "删除企业信息", httpMethod = "POST", notes = "删除企业信息")
    @ResponseBody
    public AjaxResult remove(String ids){
        return toAjax(comBaseInfoService.deleteComBaseInfoByIds(ids));
    }


}
