package com.bcxin.platform.web.controller.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.attend.AttendSchedulDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerPageDto;
import com.bcxin.platform.dto.company.ComDepartDto;
import com.bcxin.platform.service.attend.AttendSchedulService;
import com.bcxin.platform.service.company.ComDepartService;
import com.bcxin.platform.service.company.PerOrgRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤排班Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/attend/schedul")
public class AttendSchedulController extends BaseController{


    @Autowired
    private AttendSchedulService attendSchedulService;

    @Autowired
    private ComDepartService comDepartService;

    @Autowired
    private PerOrgRelationService perOrgRelationService;


    /**
     * 查询考勤排班列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AttendSchedulPerPageDto attendSchedul){
        List<AttendSchedulPerPageDto> list = attendSchedulService.selectList(attendSchedul);
        return getDataTable(list);
    }

    /**
     * 分页查询考勤排班列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage(AttendSchedulPerPageDto attendSchedul){
        startPage();
        List<AttendSchedulPerPageDto> list = attendSchedulService.selectList(attendSchedul);
        return getDataTable(list);
    }

    /**
     * 导出考勤排班列表
     */
    @Log(title = "考勤排班", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public AjaxResult export(AttendSchedulPerPageDto attendSchedul){
        List<AttendSchedulPerPageDto> list = attendSchedulService.selectList(attendSchedul);
        ExcelUtil<AttendSchedulPerPageDto> util = new ExcelUtil<AttendSchedulPerPageDto>(AttendSchedulPerPageDto.class);
        return util.exportExcel(list, "schedul");
    }


    /**
     * 修改考勤排班
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendSchedulDetail attendSchedul = attendSchedulService.findById(id);
        return AjaxResult.success(null,attendSchedul);
    }

    /**
     * 保存考勤排班
     */
    @Log(title = "考勤排班", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(AttendSchedulDto attendSchedul){
        ValidatorUtils.validateEntity(attendSchedul, AddGroup.class);
        return toAjax(attendSchedulService.save(attendSchedul));
    }

    /**
     * 删除考勤排班
     */
    @Log(title = "考勤排班", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        int deleteCount = attendSchedulService.deleteByIds(ids);
        if(deleteCount > 0){
            return AjaxResult.success();
        }
        return AjaxResult.error("删除失败，不能删除之前的班次");
    }

    /**
     * 选人公共部门树接口
     * @param comDepart
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    @PostMapping(value = "getTreeDepart")
    public AjaxResult getTreeDepart(ComDepartDto comDepart) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        comDepart.setPerID(currentUser.getPerId());
        return AjaxResult.success(null,comDepartService.getTreeDepartForAttend(comDepart));
    }

    @PostMapping(value = "getDepartPersonList")
    public AjaxResult getDepartPersonList(AttendSchedulPerDto searchDto) {
        return AjaxResult.success(null,attendSchedulService.getDepartPersonList(searchDto));
    }
}
