package com.bcxin.platform.web.controller.app.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.domain.attend.AttendAddress;
import com.bcxin.platform.domain.attend.AttendWifi;
import com.bcxin.platform.service.attend.AttendWifiService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤wifiController
 * 
 * @author lin
 * @date 2022-04-09
 */
@RestController
@RequestMapping("/app/attend/wifi")
public class AppAttendWifiController extends BaseController{

    @Autowired
    private AttendWifiService attendWifiService;

    /**
     * 查询考勤wifi列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AttendWifi attendWifi){
        List<AttendWifi> list = attendWifiService.selectList(attendWifi);
        return getDataTable(list);
    }


    /**
     * 修改保存考勤wifi
     */
    @Log(title = "考勤wifi", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(AttendWifi attendWifi){
        return toAjax(attendWifiService.update(attendWifi));
    }

    /**
     * 删除考勤wifi
     */
    @Log(title = "考勤wifi", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendWifiService.deleteByIds(ids));
    }


    /**
     * 根据id查询考勤地点详情
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendWifi attendWifi = attendWifiService.findById(id);
        return AjaxResult.success(null,attendWifi);
    }
}
