package com.bcxin.platform.web.controller.app.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.attend.AttendAddress;
import com.bcxin.platform.service.attend.AttendAddressService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤地点定位Controller
 * 
 * @author lin
 * @date 2022-04-09
 */
@RestController
@RequestMapping("/app/attend/address")
public class AppAttendAddressController extends BaseController{


    @Autowired
    private AttendAddressService attendAddressService;

    /**
     * 查询考勤地点定位列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AttendAddress attendAddress){
        List<AttendAddress> list = attendAddressService.selectList(attendAddress);
        return getDataTable(list);
    }

    /**
     * 修改保存考勤地点定位
     */
    @Log(title = "考勤地点定位", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(AttendAddress attendAddress){
        return toAjax(attendAddressService.update(attendAddress));
    }

    /**
     * 删除考勤地点定位
     */
    @Log(title = "考勤地点定位", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendAddressService.deleteByIds(ids));
    }


    /**
     * 根据id查询考勤地点详情
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendAddress attendAddress = attendAddressService.findById(id);
        return AjaxResult.success(null,attendAddress);
    }

}
