package com.bcxin.oaflow.domain;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author linqinglin
 * @date 2021/09/08 0008 17:04
 */
@Data
public class OaBusinessBaseEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 主键id */
    private String id;

    /** 人员id */
    @Excel(name = "人员id")
    private String userId;

    /** 人员姓名 */
    @Excel(name = "人员姓名")
    private String userName;

    /** 部门名称 */
    @Excel(name = "部门名称")
    private String departName;

    /** 部门ID */
    @Excel(name = "部门ID")
    private String departId;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date applicationTime;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date stopTime;

    /** 时长 */
    @Excel(name = "时长")
    private Double diffTime;

    /** 审批状态 */
    @Excel(name = "审批状态")
    private String state;

    /** 类别  0请假1加班2公出3出差*/
    private String dictType;
}
