package com.bcxin.platform.mapper.system;

import java.util.List;
import java.util.Map;

import com.bcxin.platform.domain.system.SysConfig;

/**
 * 参数配置 数据层
 *
 * @author task
 */
public interface SysConfigMapper
{
    /**
     * 查询参数配置信息
     *
     * @param config 参数配置信息
     * @return 参数配置信息
     */
    public SysConfig selectConfig(SysConfig config);

    /**
     * 查询参数配置列表
     *
     * @param config 参数配置信息
     * @return 参数配置集合
     */
    public List<SysConfig> selectConfigList(SysConfig config);

    /**
     * 根据键名查询参数配置信息
     *
     * @param configKey 参数键名
     * @return 参数配置信息
     */
    public SysConfig checkConfigKeyUnique(String configKey);

    /**
     * 新增参数配置
     *
     * @param config 参数配置信息
     * @return 结果
     */
    public int insertConfig(SysConfig config);

    /**
     * 修改参数配置
     *
     * @param config 参数配置信息
     * @return 结果
     */
    public int updateConfig(SysConfig config);

    /**
     * 批量删除参数配置
     *
     * @param configIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteConfigByIds(String[] configIds);

    /**
     * 查询系统配置信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 11:14
     * @return
     */
    List<Map<String,Object>> getSystemConfig();

    /**
     * 查询系统区域配置表
     * @author llc
     * @date 2019-04-11
     */
    List<Map<String,String>> getSysRegion();

    /**
     * 查询分发服务配置
     * @author llc
     * @date 2021-03-13
     */
    List<Map<String,Object>> getConfigBdp();
}