package com.bcxin.platform.domain.insurance;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 企业保险引导方案
 * @apiNote  作者 陈堂君
 * @since 创建于 2018/4/3 9:30
 */
@TableName("com_ins_boot_scheme")
@Data
public class ComInsBootScheme extends BaseEntity {
    /**
     * 企业保险引导方案ID
     */
    private Long comInsBootSchemeId;

    private Date createTime;

    private Long createBy;

    private Date updateTime;

    private Long updateBy;

    private String isDelete;

    /**
     * 紧急联系人
     */
    private String contactper;

    /**
     * 联系人手机号码
     */
    private String contactPhone;

    /**
     * 企业人数
     */
    private Long comPerNum;

    /**
     * 保障金额下限
     */
    private BigDecimal guaranteeAmountLow;

    /**
     * 保费上限
     */
    private BigDecimal insAmountUp;

    /**
     * 保险方案url
     */
    private String insSchemeUrl;

    /**
     * 企业ID
     */
    private Long comId;

    /**
     * 百联保产品编码
     */
    private String proCode;

    /**
     * 方案书名称
     */
    private String insBootName;

    public String getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(String isDelete) {
        this.isDelete = isDelete;
    }

    public String getContactper() {
        return contactper;
    }

    public void setContactper(String contactper) {
        this.contactper = contactper;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public BigDecimal getGuaranteeAmountLow() {
        return guaranteeAmountLow;
    }

    public void setGuaranteeAmountLow(BigDecimal guaranteeAmountLow) {
        this.guaranteeAmountLow = guaranteeAmountLow;
    }

    public BigDecimal getInsAmountUp() {
        return insAmountUp;
    }

    public void setInsAmountUp(BigDecimal insAmountUp) {
        this.insAmountUp = insAmountUp;
    }

    public String getInsSchemeUrl() {
        return insSchemeUrl;
    }

    public void setInsSchemeUrl(String insSchemeUrl) {
        this.insSchemeUrl = insSchemeUrl;
    }

    public String getProCode() {
        return proCode;
    }

    public void setProCode(String proCode) {
        this.proCode = proCode;
    }

    public String getInsBootName() {
        return insBootName;
    }

    public void setInsBootName(String insBootName) {
        this.insBootName = insBootName;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getComInsBootSchemeId() {
        return comInsBootSchemeId;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getCreateBy() {
        return createBy;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getUpdateBy() {
        return updateBy;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getComPerNum() {
        return comPerNum;
    }

    @JsonSerialize(using=ToStringSerializer.class)
    public Long getComId() {
        return comId;
    }
}