package com.bcxin.platform.domain.grant;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 企业渤海薪资发放明细
 * 
 * @author llc
 * @date 2020-08-13
 */
@Data
@TableName("com_bh_grant_detail")
public class ComBhGrantDetail extends BaseEntity<ComBhGrantDetail> {

	/** 企业渤海发放明细ID */
	@ApiModelProperty(value = "企业渤海发放明细ID")
	private Long comBhGrantDetailId;

	/** 姓名 */
	@ApiModelProperty(value = "姓名")
	private String name;

	/** 证件号码 */
	@ApiModelProperty(value = "证件号码")
	private String idCardNo;

	/** 手机号 */
	@ApiModelProperty(value = "手机号")
	private String mobilePhone;

	/** 银行卡号 */
	@ApiModelProperty(value = "银行卡号")
	private String bankCardNo;

	/** 发放金额 */
	@ApiModelProperty(value = "发放金额")
	private BigDecimal amount;

	/** 发放年月 */
	@ApiModelProperty(value = "发放年月")
	private String grantYears;

	/** 发放状态 */
	@ApiModelProperty(value = "发放状态")
	private String grantStatus;

	/** 备注 */
	@ApiModelProperty(value = "备注")
	private String remark;

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/** 企业渤海发放ID */
	@ApiModelProperty(value = "企业渤海发放ID")
	private Long comBhGrantId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComBhGrantDetailId() {
		return comBhGrantDetailId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComBhGrantId() {
		return comBhGrantId;
	}

}