package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import lombok.Data;

/**
 * 考勤请假统计对象 tb_attend_leave
 * 
 * @author lin
 * @date 2021-09-07
 */
@Data
public class AttendLeave extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 请假统计ID */
    private Long id;


    /** 是否删除 1是0否 */
    @Excel(name = "是否删除 1是0否")
    private String isDelete;

    /**
     * 请假id
     */
    private String oaLeaveId;

    /** 人员ID */
    @Excel(name = "人员ID")
    private Long perId;

    /** 部门ID */
    @Excel(name = "部门ID")
    private Long deptId;

    /** 公司ID */
    @Excel(name = "公司ID")
    private Long comId;

    /** 排班详情ID */
    @Excel(name = "排班详情ID")
    private Long schedulDetailId;

    /** 请假日期 */
    @Excel(name = "请假日期")
    private String leaveDate;

    /** 请假类型 */
    @Excel(name = "请假类型")
    private String leaveType;

    /** 请假时长 */
    @Excel(name = "请假时长")
    private Double leaveHour;

    /**
     * 勿删
     * @param o
     * @return
     */
    @Override
    public boolean equals (Object o){
        boolean retVal = false;
        if (o != null && o.getClass().equals(this.getClass())) {
            AttendLeave that = (AttendLeave) o;
            if (that.getOaLeaveId() != null && this.getOaLeaveId() != null && that.getSchedulDetailId() != null && this.getSchedulDetailId() != null){
                if (that.getOaLeaveId().equals(this.getOaLeaveId()) &&that.getSchedulDetailId().equals(this.getSchedulDetailId()) ) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    /**
     * 勿删
     * @return
     */
    @Override
    public int hashCode() {
        return getOaLeaveId().hashCode();
    }

}
