package com.bcxin.platform.mapper.grant;


import com.bcxin.platform.domain.grant.PerBankOutletsAppointment;
import org.apache.ibatis.annotations.Param;

import java.util.Map;

/**
 * 人员银行网点预约
 * @author llc
 * @date 2020-08-21
 */
public interface PerBankOutletsAppointmentMapper{

    /**
     * 插入人员银行网点预约
     * @param perBankOutletsAppointment
     * @author llc
     * @date 2020-08-21
     */
     int insertPerBankOutletsAppointment(PerBankOutletsAppointment perBankOutletsAppointment);


    /**
     * 查询人员预约信息
     * @param perId
     * @author llc
     * @date 2020-08-21
     */
    PerBankOutletsAppointment getPerBankOutletsAppointment(@Param("perId") Long perId);

    /**
     * 查询人员银行网点预约
     * @param perId
     * @author llc
     * @date 2020-08-21
     */
    Map<String,String> getPerBankOutletsAppointmentByPerId(@Param("perId") Long perId);


    /**
     * 删除人员银行网点预约
     * @param perBankOutletsAppointment
     * @author llc
     * @date 2020-08-21
     */
    int deletePerBankOutletsAppointment(PerBankOutletsAppointment perBankOutletsAppointment);

    /**
     * 校验是否可以预约
     * @param perBankOutletsAppointment
     * @author llc
     * @date 2020-08-21
     */
    String checkIsCanAppointment(PerBankOutletsAppointment perBankOutletsAppointment);

}