package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.FactorGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 考勤排班对象 tb_attend_schedul_detail
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendSchedulDetail extends BaseEntity implements Cloneable{

    private static final long serialVersionUID = 1L;

    /** 考勤排班详情ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 考勤排班ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long schedulId;

    /** 是否使用休息日套 1是0否 */
    @Excel(name = "是否使用休息日套 1是0否")
    @NotBlank(message="是否使用休息日套不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String needCalendar;

    /** 日历套ID */
    @Excel(name = "日历套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="日历套ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long calendarId;

    /** 班次ID */
    @Excel(name = "班次ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="班次ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long shiftId;

    /** 人员ID */
    @Excel(name = "人员ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="人员ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long perId;

    /** 部门ID */
    @Excel(name = "部门ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long deptId;

    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="考勤套ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long attendId;

    /** 上班日期 */
    @Excel(name = "上班日期", width = 30, dateFormat = "yyyy-MM-dd")
    @NotBlank(message="上班日期不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String schedulDate;

    /** 上班时间 */
    @Excel(name = "上班时间")
    @NotBlank(message="上班时间不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String startTime;

    /** 下班时间 */
    @Excel(name = "下班时间")
    @NotBlank(message="下班时间不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String endTime;

    /** 是否需要休息 1是0否*/
    @Excel(name = "是否需要休息")
    @NotBlank(message="是否需要休息不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String needRest;

    /** 休息开始时间 */
    @Excel(name = "休息开始时间")
    @NotBlank(message="休息开始时间不能为空", groups = {FactorGroup.class})
    private String restStart;

    /** 休息结束时间 */
    @Excel(name = "休息结束时间")
    @NotBlank(message="休息结束时间不能为空", groups = {FactorGroup.class})
    private String restEnd;

    /**
     * 类型 0休息 1上班
     */
    private String schedulType;

    //自定义类实现自己的clone()方法
    @Override
    public AttendSchedulDetail clone() throws CloneNotSupportedException {
        //通过super.clone()实现clone()方法
        return (AttendSchedulDetail) super.clone();
    }
}
