package com.bcxin.platform.service.insurance;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.blb.AjaxResult;
import com.bcxin.platform.domain.insurance.ComInsBootScheme;
import com.bcxin.platform.dto.insurance.*;
import com.bcxin.platform.util.BLBSyncDataException;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * @Author: 陈堂君
 * @Date: 2017/12/22
 * @Description:
 * @Modified By:
 */
public interface ComInsService {
	Result getComInsPage(ComInsDTO dto) throws V5BusinessException;

	Result getPerInsPage(ComInsDTO dto) throws V5BusinessException;

	Result getPerInsPageNew(ComInsDTO dto) throws V5BusinessException;

	Result getComInsByIdcard(ComInsDTO dto) throws V5BusinessException;

	Result findComInsByIdcard(ComInsDTO dto) throws V5BusinessException;

	Result deleteComInsUnderline(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 更新授权申请书地址 </b>
	 * @author ZXF
	 * @create 2020/06/05 0005 14:39
	 * @version
	 * @注意事项 </b>
	 */
	Result saveAuthFile(ComInsDTO dto) throws V5BusinessException;

	Result saveComInsUnderline(ComInsDTO dto) throws V5BusinessException;

	Result getComInsDetail(ComInsDTO dto) throws V5BusinessException;

	/**
	 * 在线企业保险链接生成
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/3 13:53
	 */
	Result getOnlineInsBlbLink(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 在线企业保险用户激活链接生成 </b>
	 * @author ZXF
	 * @create 2021/02/23 0023 13:24
	 * @version
	 * @注意事项 </b>
	 */
	Result activateOnlineInsBlbUserLink(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 初始化管理员创建为保险负责人 </b>
	 * @author ZXF
	 * @create 2019/05/24 0024 16:10
	 * @version
	 * @注意事项 </b>
	 */
	Result initSavePrincipal(Long comId, Long perId, Long createBy);

	/**
	 * 企业保险详情链接生成
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/4 11:29
	 * @param dto
	 * @return
	 */
	Result getOnlineInsBlbDetailLink(ComInsDTO dto) throws V5BusinessException;

	/**
	 * 保全页面链接生成，不带人员信息
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/3 9:56
	 */
	public Result getOnlineInsBlbPreservationPageLink(ComInsBootScheme dto);

	/**
	 * <b> 订单列表页面链接生成 </b>
	 * @author ZXF
	 * @create 2019/05/22 0022 10:20
	 * @version
	 * @注意事项 </b>
	 */
	public Result getOnlineInsBlbOrderPageLink(ComInsDTO dto);

	/**
	 * <b> 理赔列表页面链接生成 </b>
	 * @author ZXF
	 * @create 2019/05/22 0022 10:20
	 * @version
	 * @注意事项 </b>
	 */
	public Result getOnlineInsBlbReportPageLink(ComInsDTO dto);

	/**
	 * 获得百联保保险产品列表
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/3 10:00
	 */
	public Result getBlbProList(ComInsBootScheme dto);

	/**
	 * 根据缓存ID获得对应的保全人员信息
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/29 16:54
	 */
	public AjaxResult findPerIdsByCacheId(ComInsDTO dto);

	/**
	 * <b> 根据缓存ID获得已选择的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 10:35
	 * @version
	 * @注意事项 </b>
	 */
	public Result findCompnayAndPersonByCacheId(ComInsDTO dto);

	/**
	 * 企业保全列表的保险详情链接生成
	 *
	 * @param dto
	 * @return
	 */
	public Result getOnlineInsBlbPreservationLink(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 选择订单和人员信息推送到百联保做增员保全 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	public Result saveInsBlbAddPreservationService(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 选择订单和人员信息推送到百联保做减员保全 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	public Result saveInsBlbMinusPreservationService(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 选择在保未录入列表人员做减员保全 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	public Result saveInsBlbMinusPreservationByNotIncluded(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 接收页面的用户信息添加到缓存，返回生成的百联保访问地址 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 10:43
	 * @version
	 * @注意事项 </b>
	 */
	public Result findCompnayAndPersonPutCache(ComInsDTO dto) throws V5BusinessException;

	/**
	 * 保全信息回传接口
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/28 10:25
	 * @param dto
	 * @return
	 */
	public AjaxResult savePerservationInfo(BLBAPIDTO dto) throws BLBSyncDataException;

	/**
	 * <b> 被标记为线下百联保购买的保单保全信息回传接口 </b>
	 * @author ZXF
	 * @create 2022/08/25 0025 10:25
	 * @version
	 * @注意事项 </b>
	 */
	public AjaxResult saveOfflinePerservationInfo(BLBAPIDTO dto) throws BLBSyncDataException;

	/**
	 * <b> 保全缴费待支付消息处理接口 </b>
	 * @author ZXF
	 * @create 2019/05/21 0021 16:07
	 * @version
	 * @注意事项 </b>
	 */
	public AjaxResult sendInsUnpaidMsg(BLBAPIDTO dto) throws BLBSyncDataException;

	/**
	 * 企业初始化提示，根据企业所属规则去判断是否需要保险提示
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/29 14:10
	 */
	@SuppressWarnings("rawtypes")
	public Result promptInitEnterpriseIns(ComInsDTO dto) throws V5BusinessException;

	/**
	 * 保全提示，0无保险去购买，1需要做保全，
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/3/29 14:11
	 */
	public Result promptInitPerAddDelIns(ComInsDTO dto);

	/**
	 * 保存方案书
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/2 17:40
	 */
	public Result saveBookScheme(ComInsBootScheme dto) throws V5BusinessException;

	/**
	 * 根据产品编码和地区进行判断，返回对应的pdf链接
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/4 10:57
	 */
	public Result getBootSchemePdfLink(ComInsDTO dto);

	/**
	 * 读取企业初始化温馨提示的接口
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/4 16:28
	 */
	public Result promptCompanyInitGen(ComInsDTO dto);

	/**
	 * 根据保险规则通知当前登录的企业
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/17 13:48
	 * @return
	 */
	public Result sendInsPromptToCompany(ComInsDTO dto) throws V5BusinessException;

	/**
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/4/18 18:07
	 */
	public Result getInsBootPage(ComInsDTO dto) throws V5BusinessException;

	public Result delAllLosePerInfo() throws V5BusinessException;

	/**
	 * 根据企业ID获取企业的信息，为兼容对接
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/4 13:15
	 * @param dto
	 * @return
	 */
	AjaxResult findCompnayAndPersonByUserid(ComInsDTO dto) throws V5BusinessException;

	/**
	 * 保存订单信息
	 * 
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/4 17:44
	 */
	AjaxResult saveOrderInfo(BLBAPIDTO dto) throws BLBSyncDataException;

	/**
	 * 保存订单信息
	 *
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/4 17:44
	 */
	AjaxResult saveOfflineOrderPerson(BLBAPIDTO dto) throws BLBSyncDataException;

	/**
	 * <b> 保存电子保单地址 </b>
	 * @author ZXF
	 * @create 2019/05/10 0010 14:37
	 * @version
	 * @注意事项 </b>
	 */
	AjaxResult savePolicyUrl(BLBAPIDTO dto) throws BLBSyncDataException;

	/**
	 * <b> 根据百联保订单id删除saas保单信息 </b>
	 * @author ZXF
	 * @create 2019/05/10 0010 14:37
	 * @version
	 * @注意事项 </b>
	 */
	AjaxResult deletePolicy(BLBAPIDTO dto) throws BLBSyncDataException;

	/**
	 * 获取线上人员参保列表
	 * 
	 * @apiNote 作者 zhangye
	 * @since 创建于 2018/9/20 16:07
	 */
	Result getOnlineInsPerList(ComOnlineInsPerDTO dto) throws V5BusinessException;


	/**
	 * <b> 根据条件查询未投保的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	public Result findUninsuredPerList(InsPerDTO dto) throws V5BusinessException;

	/**
	 * <b> 导出根据条件筛选未投保的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:22
	 * @version
	 * @注意事项 </b>
	 */
	public void exportUninsuredPerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException;

	/**
	 * <b> 根据条件查询已过滤的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	public Result findFilterPerList(InsPerDTO dto) throws V5BusinessException;

	/**
	 * <b> 根据条件查询已投保的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	public Result findUnderWarrantyPerList(InsPerDTO dto) throws V5BusinessException;

	/**
	 * <b> 导出根据条件筛选已投保的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:22
	 * @version
	 * @注意事项 </b>
	 */
	public void exportUnderWarrantyPerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException;

	/**
	 * <b> 根据条件查询已投保未录入的人员信息 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	public Result findNotIncludedInsurancePerList(InsPerDTO dto) throws V5BusinessException;

	/**
	 * <b> 导出根据条件筛选已投保未录入的人员信息 </b>
	 * @author ZXF
	 * @create 2020/05/26 0026 10:22
	 * @version
	 * @注意事项 </b>
	 */
	public void exportNotIncludedInsurancePerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException;

	/**
	 * <b> 查询在保人员离职人数 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	public Result findYIncumbencyPerCount(InsPerDTO dto) throws V5BusinessException;

	/**
	 * <b> 查询线下或线上保险列表 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:53
	 * @version
	 * @注意事项 </b>
	 */
	public Result findOfflineOrOnlinePolicy(InsPerDTO dto) throws V5BusinessException;

	/**
	 * <b> 人员批量添加过滤记录 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	public Result addBatchFilterPerson(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 人员批量删除过滤记录 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	public Result delBatchFilterPerson(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 查询保单已关联在保人员数量 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	public Result findUnderWarrantyPerListCount(InsPerDTO dto) throws V5BusinessException;

	/**
	 * <b> 人员批量关联线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	public Result addBatchRelevancePer(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 线下保单添加备注 </b>
	 * @author ZXF
	 * @create 2020/04/20 0020 16:02
	 * @version
	 * @注意事项 </b>
	 */
	public Result updateComInsRemark(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 人员批量减员线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	public Result minusBatchRelevancePer(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 搜索未投保人员或已投保并离职人员向对应企业定时推送站内消息提醒 </b>
	 * @author ZXF
	 * @create 2019/05/21 0021 14:20
	 * @version
	 * @注意事项 </b>
	 */
	public Result sendInsuranceOperationMsg();

	/**
	 * <b> 批量删除保险负责人 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:43
	 * @version
	 * @注意事项 </b>
	 */
	public Result delBatchPrincipal(ComInsPrincipalDTO dto) throws V5BusinessException;

	/**
	 * <b> 批量插入保险负责人 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:41
	 * @version
	 * @注意事项 </b>
	 */
	public Result insertBatchPrincipal(ComInsPrincipalDTO dto) throws V5BusinessException;

	/**
	 * <b> 根据企业ID，查询保险负责人列 </b>
	 * @author ZXF
	 * @create 2019/05/17 0017 16:45
	 * @version
	 * @注意事项 </b>
	 */
	public Result selectPrincipalByComId(ComInsPrincipalDTO dto) throws V5BusinessException;

	/**
	 * <b> 搜索已投保未录入人员身份证去百联保匹配获取姓名 </b>
	 * @author ZXF
	 * @create 2020/01/06 0006 10:27
	 * @version
	 * @注意事项 </b>
	 */
	public Result findBlbPerName() throws V5BusinessException;

	/**
	 * <b> 批量人员导入处理 </b>
	 * @author ZXF
	 * @create 2020/01/15 0015 15:58
	 * @version
	 * @注意事项 </b>
	 */
	Result batchUploadInsPer(Long perId, Long comId, MultipartFile file) throws Exception;
	Result batchUploadInsPer(String tlkProjectId,Long perId, Long comId, MultipartFile file) throws Exception;

	/**
	 * <b> 批量人员导入处理(减员专用) </b>
	 * @param importBatchId 批次Id：将获取当前登录的perId当做批次Id,这样每次导入就可以将对应批次在临时表的数据删除掉
	 * @author ZXF
	 * @create 2020/01/15 0015 15:58
	 * @version
	 * @注意事项 </b>
	 */
	Result minusBatchUploadInsPer(Long importBatchId, Long comId, MultipartFile file) throws Exception;

	/**
	 * <b> 根据批次id导出该批次错误人员信息 </b>
	 * @author ZXF
	 * @create 2020/01/16 0016 14:05
	 * @version
	 * @注意事项 </b>
	 */
	Result downErrInsPer(String importBatchId, HttpServletResponse response);

	/**
	 * <b> 批量模板上传人员线上做增员 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 14:43
	 * @version
	 * @注意事项 </b>
	 */
	Result tempBatchInsPerToAddPreservationService(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 批量模板上传人员关联线下保单 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 17:55
	 * @version
	 * @注意事项 </b>
	 */
	Result tempBatchInsPerToRelevance(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 查询批量模板人员信息添加到缓存，返回生成的百联保访问地址 </b>
	 * @author ZXF
	 * @create 2019/03/26 0026 10:43
	 * @version
	 * @注意事项 </b>
	 */
	Result findCompnayAndTempBatchInsPerPutCache(ComInsDTO dto) throws V5BusinessException;

	/**
	 * <b> 定时查询线下保单中标注百联保的单子去百联保拉取在保人数 </b>
	 * @author ZXF
	 * @create 2020/04/20 0020 10:09
	 * @version
	 * @注意事项 </b>
	 */
	Result syncInsNumTaskToBLB() throws V5BusinessException;

	/**
	 * <b> APP理赔列表 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 15:58
	 * @version
	 * @注意事项 </b>
	 */
	Result reportList(BLBAPIDTO dto) throws V5BusinessException;

	/**
	 * <b> 根据身份证查询有过参与投保的保单记录 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 18:08
	 * @version
	 * @注意事项 </b>
	 */
	Result findPolicyByIdCard(BLBAPIDTO dto) throws V5BusinessException;

	/**
	 * <b> APP理赔记录详情 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 15:58
	 * @version
	 * @注意事项 </b>
	 */
	Result getReportById(BLBAPIDTO dto) throws V5BusinessException;

	/**
	 * <b> 通过图片地址上传到平安ibos平台，激活fileId并返回 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 16:35
	 * @version
	 * @注意事项 </b>
	 */
	Result getFileIdByPath(BLBAPIDTO dto) throws V5BusinessException;

	/**
	 * <b> APP提交报案信息 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 15:58
	 * @version
	 * @注意事项 </b>
	 */
	Result saveReport(BLBAPIDTO dto) throws V5BusinessException;

	/**
	 * <b> 报案理流程附件补传 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 15:58
	 * @version
	 * @注意事项 </b>
	 */
	Result saveUploadFile(BLBAPIDTO dto) throws V5BusinessException;
}
