package com.bcxin.platform.service.grant;

import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComGrantRecord;
import com.bcxin.platform.mapper.grant.ComGrantRecordMapper;
import com.bcxin.platform.util.PageInfoUtils;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 企业发放记录
 *
 * @author llc
 * @date 2020-03-27
 */
@Service
@Transactional("transactionManager")
public class ComGrantRecordServiceImpl implements ComGrantRecordService {

    @Resource
    private ComGrantRecordMapper comGrantRecordMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 获取企业发放记录列表
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    @Override
    public Result pageComGrantRecordList(ComGrantRecord comGrantRecord) throws V5BusinessException {
        if (comGrantRecord.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (comGrantRecord.getPageNumber() == null) {
            throw new V5BusinessException(Result.ERROR, "第几页不能为空");
        }
        if (comGrantRecord.getPageSize() == null) {
            throw new V5BusinessException(Result.ERROR, "每页多少行不能为空");
        }

        PageHelper.startPage(comGrantRecord.getPageNumber(), comGrantRecord.getPageSize());
        List<Map<String, Object>> comGrantRecordList = comGrantRecordMapper.pageComGrantRecordList(comGrantRecord);
        PageInfoUtils pageInfo = new PageInfoUtils(comGrantRecordList);
        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }

    /**
     * 保存企业线下发放记录
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    @Override
    public Result saveOffLineGrantRecord(ComGrantRecord comGrantRecord) throws V5BusinessException {
        if (comGrantRecord.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        /*** 如果企业发放记录ID为空则代表新增 ***/
        if (comGrantRecord.getComGrantRecordId() == null) {
            comGrantRecord.setComGrantRecordId(idWorker.nextId());
            comGrantRecord.setGrantChannel(DictConst.GRANTCHANNEL_XXFF);
            comGrantRecordMapper.insertComGrantRecord(comGrantRecord);
        }else{
            comGrantRecord.setGrantChannel(DictConst.GRANTCHANNEL_XXFF);
            comGrantRecordMapper.updateComGrantRecord(comGrantRecord);
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 删除企业线下发放记录
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    @Override
    public Result deleteOffLineGrantRecord(ComGrantRecord comGrantRecord) throws V5BusinessException {
        if (comGrantRecord.getComGrantRecordId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业发放记录ID不能为空");
        }
        comGrantRecordMapper.deleteComGrantRecordById(comGrantRecord);
        return Result.success(Result.SUCCESS_MSG);
    }



}