package com.bcxin.platform.service.common;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.BusinessLog;
import com.bcxin.platform.domain.system.SysRegion;
import com.bcxin.platform.domain.company.ConfigIndustryDict;
import com.bcxin.platform.dto.grant.ConfigBankOutletsDTO;
import com.bcxin.platform.util.http.HuaWeiSmsContent;

import java.util.List;
import java.util.Map;

/**
 * 企业班次
 *
 * @author zhangye
 * @since 2018-02-26 13:42:27
 */
public interface CommonService {

    /**
     *  发送消息（调用罗总发送消息方法）
     *
     * @param tilte 标题
     * @param content 内容
     * @param messageType 消息类型
     * @param ids 接收人id，多个用,隔开
     * @apiNote 作者 zhongjianhui
     * @since 创建于 2018年4月23日 10:00:36
     */
    void sendMessageToApp(String tilte, String content, String messageType, String ids, Long comId, Long taskId);

    /**
     * @param businessLog
     * @throws V5BusinessException
     * @Author: zhangjianhua
     * @Description:日志
     */
    void BunissLogDemo(BusinessLog businessLog) throws V5BusinessException;

    /**
     * 得到库表的配置信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/2 15:46
     * @param key
     * @return value
     */
    String getSystemConfig(String key);

    /**
     * <b> 字符串存redis </b>
     * @author ZXF
     * @create 2019/10/11 0011 16:56
     * @version
     * @注意事项 </b>
     */
    void setConditions(String key, String value);

    String getConditions(String key);

    /**
     * 通过ID查询 当个地区
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2017/12/21 20:10
     */
    Result getRegionById(SysRegion sysRegion);

    /**
     * 得到地区，根据父节点ID
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2017/12/21 20:10
     */
    Result getRegionByParentId(SysRegion sysRegion);

    /**
     * 通过等级level 来查询列表
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2017/12/21 20:11
     */
    Result getRegionByLevel(SysRegion sysRegion);

    /**
     * 查询地区，对象{}，key为地区编码，value为实体的map
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2017/12/21 20:11
     */
    Result getRegionAsObj();

    /**
     * 得到地区的信息列表，带递归
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2017/12/21 20:12
     */
    Result getRegions();

    /**
     * @Author: wangcy
     * @Description:通过ID查询 多个地区
     * @Date: 2018/01/23 0023 16:12
     */
    Result getRegionList(String sysRegionList);

    /**
     * 根据地区名称获取地区对象
     *
     * @param regionName 地区名称
     * @return
     */
    Result getRegionByName(String regionName);

    /**
     * 返回银行编码表（key）
     * 由于redisKey对应的value存在变动手动删除不方便
     *
     * @author lp
     * @date 2019-09-06
     */
    String getConfigBank(String key);

    /**
     * 返回银行编码表
     * 由于redisKey对应的value存在变动手动删除不方便
     * @author llc
     * @date 2019-06-24
     */

    Result getConfigBankList();

    /**
     * 发送审批消息（调用罗总发送消息方法）
     *
     * @param tilte
     *            标题
     * @param content
     *            内容
     * @param messageType
     *            消息类型
     * @param emails
     *            接收人id，多个用,隔开
     * @author ZXF
     * @create 2018/11/06 0006 17:27
     * @version
     * @注意事项 </b>
     */
    void sendEmailMessage(String tilte, String content, String messageType, String emails);

    Result getConfigDictById(String codeTypes);

    /**
     * 行业字典查询，通过企业ID
     *
     * @param cid
     * @apiNote 作者 zxf
     * @since 创建于 2018/09/20 15:18
     */
    Result getConfigIndustryDictByComId(ConfigIndustryDict cid);

    /**
     * 机构字典查询，通过行业值
     * @param industryType 行业
     * @apiNote 作者 zxf
     * @since 创建于 2018/09/20 15:18
     */
    Result getInstitutionTypeByIndustryType(String industryType);

    /**
     * 获得保障项目列表
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/3/2 16:36
     */
    public Result getInsProjects();

    /**
     * 分发服务配置表缓存
     * @param key
     * @author llc
     * @date 2021-03-13
     */
    Map<String,String> getConfigBdp(String key);

    /**
     * 通过接口删除redisKey方便下次加载
     * 由于redisKey对应的value存在变动手动删除不方便
     * @author llc
     * @date 2019-05-10
     */
    Result deleteRedisByKey(String key);

    String sendCode(String mobile);

    Result sendVerificationCode(String mobile);

    Result verificationCode(String mobile, String code);

    /**
     * 批量发送短信信息
     *
     * @param list
     * @return
     */
    Result sendBatchSMS(List<Map<String, String>> list, String smsCode);

    void  sendSMS(HuaWeiSmsContent huaWeiSmsContent);

    String getComManageHuaweiMeetAccessToken(String userName, String passWord, String comId);

    /**
     * <b> 获取IAM用户Token（使用密码） </b>
     * @param comId
     * @author ZXF
     * @create 2020/05/27 0027 14:46
     * @version
     * @注意事项 </b>
     */
    String getHuaweiMeetIAMTokens(Long comId);

    List<ConfigBankOutletsDTO> getConfigBankOutlets();
}