package com.bcxin.platform.domain.grant;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 企业发放记录
 * 
 * @author llc
 * @date 2020-03-27
 */
@Data
@TableName("com_grant_record")
public class ComGrantRecord extends BaseEntity<ComGrantRecord> {

	/** 企业发放记录ID */
	@ApiModelProperty(value = "企业发放记录ID")
	private Long comGrantRecordId;

	/** 发放年月 */
	@ApiModelProperty(value = "发放年月")
	private String grantYears;

	/** 发放总额 */
	@ApiModelProperty(value = "发放总额")
	private BigDecimal sumAmount;

	/** 发放总笔数 */
	@ApiModelProperty(value = "发放总笔数")
	private Integer grantCount;

	/** 发放日期 */
	@ApiModelProperty(value = "发放日期")
	private Date grantDate;

	/** 发放方式 */
	@ApiModelProperty(value = "发放方式")
	private String grantMode;

	/** 发放渠道 */
	@ApiModelProperty(value = "发放渠道")
	private String grantChannel;

	/** 发放机构名称 */
	@ApiModelProperty(value = "发放机构名称")
	private String grantOrgName;

	/** 发放凭证url */
	@ApiModelProperty(value = "发放凭证url")
	private String grantVoucherUrl;

	/** 企业发放ID */
	@ApiModelProperty(value = "企业发放ID")
	private Long comGrantId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComGrantId() {
		return comGrantId;
	}

}