package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * 考勤排班冲突详情对象 tb_attend_schedul_conflict_detail
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendSchedulConflictDetail extends BaseEntity implements Cloneable{

    private static final long serialVersionUID = 1L;

    /** 考勤排班详情ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long conflictId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long SchedulDetailId;



    //自定义类实现自己的clone()方法
    @Override
    public AttendSchedulConflictDetail clone() throws CloneNotSupportedException {
        //通过super.clone()实现clone()方法
        return (AttendSchedulConflictDetail) super.clone();
    }
}
