/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.config.kafka;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;

@Configuration
@EnableKafka
@ConditionalOnProperty(value={"spring.kafka.bootstrap-servers"}, matchIfMissing=false)
public class KafkaConfig {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConfig.class);
    private final String TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_PROJECT = "baibaodunflow.binlog-cdc.topic.v2.tlk_temporary_protection_project";
    @Value(value="${spring.kafka.bootstrap-servers}")
    private String bootstrapServer;
    @Value(value="${spring.kafka.consumer.enable-auto-commit}")
    private Boolean autoCommit;
    @Value(value="${spring.kafka.consumer.group-id}")
    private String groupId;
    @Value(value="${spring.kafka.consumer.auto-offset-reset}")
    private String autoOffsetReset;
    @Value(value="${spring.kafka.listener.ack-mode}")
    private ContainerProperties.AckMode ackMode;

    @Bean
    public NewTopic topics() {
        int partitionCount = 5;
        short replicaCount = 1;
        return new NewTopic("baibaodunflow.binlog-cdc.topic.v2.tlk_temporary_protection_project", partitionCount, replicaCount);
    }

    @Bean
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> kafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        ContainerProperties containerProperties = factory.getContainerProperties();
        containerProperties.setPollTimeout(30000L);
        containerProperties.setAckMode(this.ackMode);
        factory.setBatchListener(Boolean.valueOf(true));
        factory.setAutoStartup(Boolean.valueOf(true));
        factory.setConcurrency(Integer.valueOf(2));
        factory.setMissingTopicsFatal(true);
        return factory;
    }

    @Bean
    public ConsumerFactory<String, String> consumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigs());
    }

    @Bean
    public Map<String, Object> consumerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.bootstrapServer);
        props.put("enable.auto.commit", this.autoCommit);
        props.put("group.id", this.groupId);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.put("auto.offset.reset", this.autoOffsetReset);
        props.put("fetch.min.bytes", 512);
        props.put("request.timeout.ms", "60000");
        props.put("fetch.max.wait.ms", 3000);
        return props;
    }
}

