/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.order;

import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.order.ComOrder;
import com.bcxin.platform.domain.order.ComOrderConfirmPay;
import com.bcxin.platform.domain.order.ComOrderDetail;
import com.bcxin.platform.domain.product.ProductCoupon;
import com.bcxin.platform.dto.meeting.MeetingOrderRequestDTO;
import com.bcxin.platform.dto.meeting.OrderDTO;
import com.bcxin.platform.dto.meeting.ResourceItemDTO;
import com.bcxin.platform.dto.order.ComOrderDto;
import com.bcxin.platform.dto.order.ComOrderPayDTO;
import com.bcxin.platform.dto.order.ComOrderVo;
import com.bcxin.platform.mapper.order.ComOrderConfirmPayMapper;
import com.bcxin.platform.mapper.order.ComOrderDetailMapper;
import com.bcxin.platform.mapper.order.ComOrderMapper;
import com.bcxin.platform.mapper.product.ProductCouponMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.meeting.HuaweiMeetMatchService;
import com.bcxin.platform.service.order.ComOrderService;
import com.bcxin.platform.service.system.ISysConfigService;
import com.bcxin.platform.service.wallet.ComWalletPaymentService;
import com.bcxin.platform.util.ObjectUtils;
import com.bcxin.platform.util.PageInfoUtils;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ComOrderServiceImpl
implements ComOrderService {
    @Resource
    private ComOrderMapper comOrderMapper;
    @Resource
    private ComOrderDetailMapper comOrderDetailMapper;
    @Resource
    private IdWorker idWorker;
    @Resource
    private ComWalletPaymentService comWalletPaymentService;
    @Resource
    private ISysConfigService sysConfigService;
    @Resource
    private CommonService commonService;
    @Resource
    private ProductCouponMapper productCouponMapper;
    @Resource
    private ComOrderConfirmPayMapper comOrderConfirmPayMapper;
    @Autowired
    private HuaweiMeetMatchService comHuaweiMeetMatchService;

    @Override
    public Result checkOrder(ComOrderDto dto) throws V5BusinessException {
        if (dto.getActualPayAmount() == null) {
            return Result.fail((String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComOrderPayDTO orderPayDto = new ComOrderPayDTO();
        orderPayDto.setActualPayAmount(dto.getActualPayAmount());
        String meetIncomeComId = this.sysConfigService.selectConfigByKey("MEET_INCOME_COMID");
        orderPayDto.setInComId(Long.parseLong(meetIncomeComId));
        orderPayDto.setComId(dto.getComId());
        Result result = this.comWalletPaymentService.payValidate(orderPayDto);
        return result;
    }

    @Override
    public Result saveOrder(ComOrderDto dto) throws V5BusinessException {
        if (StringUtils.isEmpty((String)dto.getActiveCode())) {
            return Result.fail((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getOrderDetailListStr())) {
            return Result.fail((String)"\u8ba2\u5355\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getProductCategoryType())) {
            return Result.fail((String)"\u4ea7\u54c1\u8303\u7574\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount() == null) {
            return Result.fail((String)"\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BigDecimal.ZERO.compareTo(dto.getAmount()) == 0) {
            return Result.fail((String)"\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a0");
        }
        if (dto.getActualPayAmount() == null) {
            return Result.fail((String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ProductCoupon productCoupon = new ProductCoupon();
        if (dto.getProductCouponId() != null) {
            productCoupon = this.productCouponMapper.getProductCouponById(dto.getProductCouponId(), dto.getProductCategoryType());
            if (productCoupon == null) {
                return Result.fail((String)"\u4f18\u60e0\u5238\u7801\u65e0\u6548");
            }
            Date now = new Date();
            if (productCoupon.getStartTime().after(now)) {
                return Result.fail((String)"\u4f18\u60e0\u5238\u672a\u751f\u6548");
            }
            if ("1".equals(productCoupon.getCouponStatus())) {
                return Result.fail((String)"\u4f18\u60e0\u5238\u5df2\u4f7f\u7528");
            }
            if (productCoupon.getExpireTime().before(now)) {
                return Result.fail((String)"\u4f18\u60e0\u5238\u5df2\u8fc7\u671f");
            }
        }
        Long comOrderId = this.idWorker.nextId();
        dto.setComOrderId(comOrderId);
        List orderDetailList = JSON.parseArray((String)dto.getOrderDetailListStr(), ComOrderDetail.class);
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (ComOrderDetail comOrderDetail : orderDetailList) {
            comOrderDetail.setComOrderDetailId(this.idWorker.nextId());
            comOrderDetail.setComOrderId(comOrderId);
            comOrderDetail.setComId(dto.getComId());
            comOrderDetail.setCreateTime(dto.getCreateTime());
            comOrderDetail.setCreateBy(dto.getCreateBy());
            String type = comOrderDetail.getProductBuyModeId().substring(6, 8);
            Integer dateType = "01".equals(type) ? 2 : ("02".equals(type) ? 1 : 0);
            Date expireTime = null;
            if (dateType != 0) {
                try {
                    Date nowDate = DateUtil.convertStringToDate((String)DateUtil.getCurrentDate());
                    expireTime = DateUtil.dateAdd2((int)dateType, (Date)nowDate, (int)comOrderDetail.getDuration());
                }
                catch (Exception e) {
                    throw new V5BusinessException("-2", "\u5230\u671f\u65f6\u95f4\u52a0\u8f7d\u5931\u8d25\uff0cERROR:" + e.getMessage());
                }
            }
            comOrderDetail.setExpireTime(expireTime);
            sumAmount = sumAmount.add(comOrderDetail.getAmount());
        }
        if (sumAmount.compareTo(dto.getAmount()) != 0) {
            return Result.fail((String)"\u8ba2\u5355\u603b\u989d\u548c\u8ba2\u5355\u660e\u7ec6\u91d1\u989d\u4e4b\u548c\u4e0d\u4e00\u81f4");
        }
        ComOrderPayDTO orderPayDto = new ComOrderPayDTO();
        orderPayDto.setActualPayAmount(dto.getActualPayAmount());
        String meetIncomeComId = this.sysConfigService.selectConfigByKey("MEET_INCOME_COMID");
        orderPayDto.setInComId(Long.parseLong(meetIncomeComId));
        orderPayDto.setComId(dto.getComId());
        orderPayDto.setComment("");
        orderPayDto.setActiveCode(dto.getActiveCode());
        Result result = this.comWalletPaymentService.actualPay(orderPayDto);
        if (result != null && "0".equals(result.getRetType())) {
            dto.setOrderStatus("1");
            dto.setOrderDeployStatus("0");
            dto.setPurchaseStatus("0");
            this.comOrderMapper.insertComOrder(dto);
            int count = this.comOrderDetailMapper.insertComOrderDetailList(orderDetailList);
            if (count != orderDetailList.size()) {
                return Result.success((String)"\u751f\u6210\u8ba2\u5355\u51fa\u9519");
            }
            if (productCoupon.getProductCouponId() != null) {
                productCoupon.setCouponStatus("1");
                productCoupon.setComId(dto.getComId());
                productCoupon.setUseTime(new Date());
                productCoupon.setComOrderId(comOrderId);
                this.productCouponMapper.updateProductCouponById(productCoupon);
            }
            String title = "\u65b0\u63a5\u5230\u4f01\u4e1a\u4e0b\u7684\u8ba2\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff01";
            String content = "\u60a8\u6709\u65b0\u7684\u4e91\u4f1a\u8bae\u8ba2\u5355\uff0c\u8bf7\u767b\u5f55OSP\u8fd0\u8425\u652f\u6491\u540e\u53f0-\u3010\u4e1a\u52a1\u7ba1\u7406\u3011-\u3010\u4e91\u4f1a\u8bae\u7ba1\u7406\u3011-\u3010\u8ba2\u5355\u67e5\u8be2\u3011\u8fdb\u884c\u5904\u7406\u3002";
            String emails = this.sysConfigService.selectConfigByKey("ORDER_YW_EMAIL");
            this.commonService.sendEmailMessage(title, content, "010301", emails);
            return Result.success((String)"\u652f\u4ed8\u6210\u529f");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result getOrderList(ComOrderDto dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u6761\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<ComOrderDto> orderList = this.comOrderMapper.getComOrderList(dto);
        if (orderList != null && orderList.size() > 0) {
            ArrayList<Long> orderIdList = new ArrayList<Long>();
            for (ComOrderDto comOrderDto : orderList) {
                orderIdList.add(comOrderDto.getComOrderId());
            }
            List<Map<String, Object>> orderDetailList = this.comOrderDetailMapper.getOrderDetailListByOrderIdS(orderIdList);
            for (ComOrderDto orderDto : orderList) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (Map<String, Object> map : orderDetailList) {
                    if (!ObjectUtils.equals(orderDto.getComOrderId(), map.get("comOrderId"))) continue;
                    list.add(map);
                }
                orderDto.setOrderDetailList(list);
            }
        }
        return Result.success((String)"", new PageInfoUtils<ComOrderDto>(orderList));
    }

    @Override
    public List<Map<String, String>> getOrderDetailListByAssignedOrgId(ComOrderDto dto) throws PlatFormBusinessException {
        return this.comOrderDetailMapper.getOrderDetailListByAssignedOrgId(dto.getAssignedOrgId());
    }

    @Override
    public List<ComOrderVo> orderList(ComOrderVo dto) throws PlatFormBusinessException {
        List<ComOrderVo> orderList = this.comOrderMapper.getOrderList(dto);
        if (orderList != null && orderList.size() > 0) {
            ArrayList<Long> orderIdList = new ArrayList<Long>();
            for (ComOrderVo comOrderDto : orderList) {
                orderIdList.add(comOrderDto.getComOrderId());
            }
            List<Map<String, Object>> orderDetailList = this.comOrderDetailMapper.getOrderDetailListByOrderIdS(orderIdList);
            for (ComOrderVo orderDto : orderList) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (Map<String, Object> map : orderDetailList) {
                    if (!ObjectUtils.equals(orderDto.getComOrderId(), map.get("comOrderId"))) continue;
                    list.add(map);
                }
                orderDto.setOrderDetailList(list);
            }
        }
        orderList.stream().filter(s -> {
            StringBuilder a = new StringBuilder();
            for (int i = 0; i < s.getOrderDetailList().size(); ++i) {
                Map<String, Object> map = s.getOrderDetailList().get(i);
                a.append(map.get("productTypeName").toString()).append(" (").append(map.get("productName")).append(") ").append(map.get("eachAmount")).append("").append(map.get("unit")).append(" ").append("\u6570\u91cf").append(map.get("num")).append("\u4e2a").append("<br>");
            }
            s.setOrderDetailListStr(a.toString());
            return true;
        }).collect(Collectors.toList());
        return orderList;
    }

    @Override
    public Result changeDeployStatus(ComOrderDto dto) throws Exception {
        this.comOrderMapper.changeDeployStatus(dto);
        return null;
    }

    public Integer sendEmailJob() throws Exception {
        return this.comOrderMapper.selectCount("0");
    }

    @Override
    public Result getOrderStatistic(ComOrderDto dto) {
        return Result.success((String)"", (Object)this.comOrderMapper.getComOrderStatistic(dto));
    }

    @Override
    public Object findOrderPayListByOrderId(ComOrderDto dto) {
        return this.comOrderConfirmPayMapper.selectByComOrderId(dto.getComOrderId());
    }

    @Override
    public Result purchasingResource(ComOrderDto dto, Long perId) throws PlatFormBusinessException {
        if (dto.getComOrderId() == null) {
            return Result.fail((String)"comOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Map<String, String>> mapList = this.comOrderDetailMapper.getOrderDetailListByOrderId(dto.getComOrderId());
        if (mapList.size() == 0) {
            return Result.fail((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u8be6\u60c5");
        }
        MeetingOrderRequestDTO morDTO = new MeetingOrderRequestDTO();
        ArrayList order_list = Lists.newArrayList();
        Long comId = null;
        for (Map<String, String> map : mapList) {
            if (comId == null) {
                comId = Long.parseLong(map.get("comId"));
            }
            OrderDTO oDTO = new OrderDTO();
            oDTO.setDuration(map.get("duration"));
            if (StringUtils.isNotEmpty((String)map.get("delivery_address_id"))) {
                oDTO.setDelivery_address_id(map.get("delivery_address_id"));
            }
            oDTO.setDuration_type(map.get("duration_type"));
            ArrayList res_list = Lists.newArrayList();
            ResourceItemDTO riDTO = new ResourceItemDTO();
            riDTO.setService_type(map.get("service_type"));
            riDTO.setRes_spec_code(map.get("res_spec_code"));
            riDTO.setRes_size(map.get("res_size"));
            riDTO.setRes_type(map.get("res_type"));
            res_list.add(riDTO);
            oDTO.setRes_list(res_list);
            order_list.add(oDTO);
        }
        morDTO.setOrder_list(order_list);
        Result result = this.comHuaweiMeetMatchService.purchasingResource(morDTO);
        if ("0".equals(result.getRetType())) {
            String orderNos = String.valueOf(result.getData());
            if (StringUtils.isNotEmpty((String)orderNos)) {
                this.comOrderConfirmPayMapper.batchInsert(dto.getComOrderId(), Arrays.asList(orderNos.split(",")));
                ComOrder order = new ComOrder();
                order.setComOrderId(dto.getComOrderId());
                order.setPurchaseStatus("1");
                order.setUpdateBy(perId);
                order.setUpdateTime(new Date());
                this.comOrderMapper.update(order);
            } else {
                return Result.fail((String)"\u534e\u4e3a\u4e0b\u5355\u672a\u8fd4\u56de\u8ba2\u5355\u53f7\uff01");
            }
        }
        return result;
    }

    @Override
    public Result orderConfirmPay(ComOrderVo dto, Long perId) throws PlatFormBusinessException {
        if (dto.getComOrderId() == null) {
            return Result.fail((String)"comOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Result result = this.comHuaweiMeetMatchService.orderPayByOrderNo(dto.getOrderNo());
        if ("0".equals(result.getRetType()) && result.getData() != null) {
            ComOrderConfirmPay pay = new ComOrderConfirmPay();
            pay.setComOrderId(dto.getComOrderId());
            pay.setOrderNo(dto.getOrderNo());
            pay.setTradeNo(String.valueOf(result.getData()));
            this.comOrderConfirmPayMapper.update(pay);
            List<String> list = this.comOrderConfirmPayMapper.findUnConfirmPayOrderNosByOrderId(dto.getComOrderId());
            if (list.size() == 0) {
                ComOrder order = new ComOrder();
                order.setComOrderId(dto.getComOrderId());
                order.setPurchaseStatus("2");
                order.setUpdateBy(perId);
                order.setUpdateTime(new Date());
                this.comOrderMapper.update(order);
                return Result.success((String)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f", (Object)"1");
            }
            return Result.success((String)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result allocationResource(ComOrderDto dto, Long perId) throws PlatFormBusinessException {
        if (dto.getComOrderId() == null) {
            return Result.fail((String)"comOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAssignedOrgId() == null) {
            return Result.fail((String)"assignedOrgId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComOrder order = new ComOrder();
        order.setComOrderId(dto.getComOrderId());
        order.setAssignedOrgId(dto.getAssignedOrgId());
        order.setAssignedOrgType(dto.getAssignedOrgType());
        order.setOrderDeployStatus("1");
        order.setUpdateBy(perId);
        order.setUpdateTime(new Date());
        this.comOrderMapper.update(order);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result delComResource() throws PlatFormBusinessException {
        List<Map<String, String>> mapList = this.comOrderDetailMapper.findDueOrderList();
        if (mapList.size() == 0) {
            return Result.fail((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u8be6\u60c5");
        }
        ArrayList list = Lists.newArrayList();
        ArrayList failList = Lists.newArrayList();
        String huaweiComId = "";
        int num = 0;
        for (Map<String, String> map : mapList) {
            int count;
            ++num;
            if (StringUtils.isNotEmpty((String)huaweiComId) && !huaweiComId.equals(map.get("huaweiComId"))) {
                this.getDelResource(list, failList, huaweiComId);
                huaweiComId = map.get("huaweiComId");
                list = Lists.newArrayList();
            }
            if (StringUtils.isEmpty((String)huaweiComId)) {
                huaweiComId = map.get("huaweiComId");
            }
            if ("1".equals(map.get("isRecord")) && (count = Integer.parseInt(map.get("count"))) > 1) {
                for (int i = 0; i < count - 1; ++i) {
                    String id = map.get("id") + String.valueOf(i);
                    list.add(id);
                }
            }
            list.add(map.get("id"));
            if (num != mapList.size()) continue;
            this.getDelResource(list, failList, huaweiComId);
        }
        if (failList.size() > 0) {
            List<Map<String, String>> details = this.comOrderDetailMapper.getAssignedOrgNameByComOrderDetailIds(failList);
            String emails = this.commonService.getSystemConfig("ORDER_YW_EMAIL");
            String title = "\u4f01\u4e1a\u8d44\u6e90\u5373\u5c06\u5230\u671f\u672a\u80fd\u5b8c\u6210\u91ca\u653e\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff01";
            String content = "\u5b9a\u65f6\u4f01\u4e1a\u8d44\u6e90\u56de\u6536\u8fc7\u7a0b\u4e2d\uff0c\u90e8\u5206\u8d44\u6e90\u672a\u80fd\u5b8c\u6210\u91ca\u653e\uff0c\u8bf7\u53ca\u65f6\u767b\u5f55\u534e\u4e3a\u4e91\u5e73\u53f0\u5bf9\u76f8\u5173\u5df2\u5206\u914d\u8d44\u6e90\u8fdb\u884c\u5220\u9664\uff01\n\u6d89\u53ca\u8d44\u6e90\u4fe1\u606f\uff1a\n";
            StringBuffer tal = new StringBuffer();
            for (Map<String, String> map : details) {
                tal.append("        " + map.get("assignedOrgName") + "\uff1a" + map.get("productName") + "\uff08" + map.get("num") + "\uff09");
            }
            content = content + tal;
            this.commonService.sendEmailMessage(title, content, "010301", emails);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private void getDelResource(List<String> list, List<String> failList, String huaweiComId) throws PlatFormBusinessException {
        String[] arr = new String[list.size()];
        list.toArray(arr);
        Result result = this.comHuaweiMeetMatchService.delResource(arr, Long.parseLong(huaweiComId));
        if (!"0".equals(result.getRetType())) {
            failList.addAll(list);
        }
    }
}

