/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.config.kafka;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.utils.spring.SpringUtils;
import com.bcxin.platform.components.HttpMethod;
import com.bcxin.platform.components.JsonProvider;
import com.bcxin.platform.domain.temporary.ComProject;
import com.bcxin.platform.domain.temporary.ComProjectPer;
import com.bcxin.platform.service.temporary.ComProjectService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.kafka.bootstrap-servers"}, matchIfMissing=false)
public class KafkaConsumerListener {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumerListener.class);
    private final String TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON = "baibaodunflow.binlog-cdc.topic.v2.tlk_project_person";
    private final String TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_PROJECT = "baibaodunflow.binlog-cdc.topic.v2.tlk_temporary_protection_project";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DependsOn(value={"batchFactory"})
    @KafkaListener(id="${spring.kafka.consumer.group-id}-group-v8-baibaodunflow-2-tlk_temporary_protection_project", topics={"baibaodunflow.binlog-cdc.topic.v2.tlk_temporary_protection_project"}, groupId="${spring.kafka.consumer.group-id}-group-v8-baibaodunflow-2-tlk_temporary_protection_project")
    public void ackTemporaryProtectionProjectListener(List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        boolean allowed2CommitAtFinial = true;
        try {
            ComProjectService comProjectService = (ComProjectService)SpringUtils.getBean(ComProjectService.class);
            AtomicInteger count = new AtomicInteger();
            records.stream().forEach(ii -> {
                try {
                    System.out.println("0.======> " + (String)ii.value());
                    Map mapB = (Map)JSONObject.parseObject((String)((String)ii.value()), Map.class);
                    if (mapB.get("after") != null) {
                        Map map = (Map)JSONObject.parseObject((String)JSON.toJSONString(mapB.get("after")), Map.class);
                        System.out.println("1.======> " + map.toString());
                        ComProject project = ComProject.build((String)(map.get("ID") + ""), (String)(map.get("ITEM_PROJECT_NAME") + ""), (String)(map.get("ITEM_PROJECT_TYPE") + ""), (String)(map.get("DOMAINID") + ""), (Date)(map.get("ITEM_PROJECT_START_TIME") != null ? new Date(Long.parseLong(map.get("ITEM_PROJECT_START_TIME") + "")) : null), (Date)(map.get("ITEM_PROJECT_END_TIME") != null ? new Date(Long.parseLong(map.get("ITEM_PROJECT_END_TIME") + "")) : null), (String)(map.get("ITEM_ATTENDANCESITELONGITUDE") + "," + map.get("ITEM_ATTENDANCESITELATITUDE")), (String)(map.get("ITEM_ATTENDANCESITEFULLADDRESS") + ""));
                        System.out.println("2.======> " + JSON.toJSONString((Object)project));
                        comProjectService.save(project);
                        System.out.println("3.======> " + JSON.toJSONString((Object)project));
                        count.getAndIncrement();
                    }
                }
                catch (Exception ex) {
                    logger.error("======> \u5904\u7406\u4e34\u4fdd\u9879\u76ee\u4fe1\u606f\u5f02\u5e38", (Throwable)ex);
                }
            });
            logger.error("\u6210\u529f\u4ece\u7f13\u5b58\u4e2d\u5904\u7406{}\u6761\u7684\u4e34\u4fdd\u9879\u76ee\u4fe1\u606f", (Object)count.get());
        }
        catch (Exception ex) {
            logger.error("\u65b0\u589e\u4e34\u4fdd\u9879\u76ee\u4fe1\u606f\u5f02\u5e38", (Throwable)ex);
            allowed2CommitAtFinial = false;
        }
        finally {
            if (allowed2CommitAtFinial) {
                ack.acknowledge();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DependsOn(value={"batchFactory"})
    @KafkaListener(id="${spring.kafka.consumer.group-id}-group-v8-baibaodunflow-2-tlk_project_person", topics={"baibaodunflow.binlog-cdc.topic.v2.tlk_project_person"}, groupId="${spring.kafka.consumer.group-id}-group-v8-baibaodunflow-2-tlk_project_person")
    public void ackProjectPersonListener(List<ConsumerRecord<String, String>> records, Acknowledgment ack) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        boolean allowed2CommitAtFinial = true;
        try {
            List pers = Collections.synchronizedList(new ArrayList());
            ArrayList ids = new ArrayList();
            records.stream().forEach(ii -> {
                System.out.println("======> " + (String)ii.value());
                Map mapB = (Map)JSONObject.parseObject((String)((String)ii.value()), Map.class);
                if (mapB.get("after") != null) {
                    Map map = (Map)JSONObject.parseObject((String)JSON.toJSONString(mapB.get("after")), Map.class);
                    ComProjectPer per = new ComProjectPer();
                    per.setTlkProjectPerId(map.get("ID") + "");
                    per.setTlkPerId(map.get("ITEM_PERSON_ID") + "");
                    per.setTlkProjectId(map.get("ITEM_PROJECT_ID") + "");
                    per.setTlkComId(map.get("DOMAINID") + "");
                    per.setCreateTime(new Date());
                    pers.add(per);
                } else if (mapB.get("before") != null) {
                    Map map = (Map)JSONObject.parseObject((String)JSON.toJSONString(mapB.get("before")), Map.class);
                    ids.add(map.get("ID") + "");
                }
            });
            ComProjectService comProjectService = (ComProjectService)SpringUtils.getBean(ComProjectService.class);
            if (!CollectionUtils.isEmpty(pers)) {
                comProjectService.savePer(pers);
            }
            if (!CollectionUtils.isEmpty(ids)) {
                comProjectService.batchDelete(ids.toArray(new String[0]));
            }
            logger.error("\u6210\u529f\u4ece\u7f13\u5b58\u4e2d\u5904\u7406{}\u6761\u7684\u6388\u6743\u4fe1\u606f", (Object)pers.size());
        }
        catch (Exception ex) {
            logger.error("\u6d88\u8d39\u7528\u6237\u89d2\u8272\u4fe1\u606f\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            allowed2CommitAtFinial = false;
        }
        finally {
            if (allowed2CommitAtFinial) {
                ack.acknowledge();
            }
        }
    }

    private Collection<String> extractValue(String debeziumJsonValue, String field) {
        JSONObject after;
        if (!StringUtils.hasLength((String)debeziumJsonValue)) {
            return Collections.EMPTY_LIST;
        }
        JSONObject rootNode = (JSONObject)((JsonProvider)SpringUtils.getBean(JsonProvider.class)).getData(debeziumJsonValue, JSONObject.class);
        if (rootNode == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<JSONObject> allNodes = new HashSet<JSONObject>();
        JSONObject before = rootNode.getJSONObject("before");
        if (before != null) {
            allNodes.add(before);
        }
        if ((after = rootNode.getJSONObject("after")) != null) {
            allNodes.add(after);
        }
        Collection employeeIds = allNodes.stream().map(ii -> {
            String selectedKey = ii.keySet().stream().filter(fi -> fi.equalsIgnoreCase(field)).findFirst().orElse(null);
            if (StringUtils.hasLength((String)selectedKey)) {
                return ii.getString(selectedKey);
            }
            return null;
        }).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.toSet());
        return employeeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRefreshInstanceUserCache(HttpMethod method, String serviceUrl, String urlFormat, Object params) {
        String targetUrl = String.format(urlFormat, serviceUrl);
        try (CloseableHttpClient httpClient = null;){
            httpClient = HttpClientBuilder.create().build();
            HttpPost put = new HttpPost(targetUrl);
            if (method == HttpMethod.PUT) {
                put = new HttpPut(targetUrl);
            }
            String json = ((JsonProvider)SpringUtils.getBean(JsonProvider.class)).getJson(params);
            put.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)put);
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            logger.error("\u63a8\u9001\u8868\u5355\u6570\u636e\u81f3{}-\u6570\u636e={} \u4fdd\u5b58\u7ed3\u679c\u4e3a:{}-{}", new Object[]{put.getURI(), json, response.getStatusLine(), result});
        }
        catch (Exception ex) {
            logger.error("\u5237\u65b0runtime({})\u7ec4\u4ef6\u7f13\u5b58\u53d1\u751f\u5f02\u5e38:{}", new Object[]{targetUrl, ((JsonProvider)SpringUtils.getBean(JsonProvider.class)).getJson(params), ex});
        }
    }
}

