UPDATE `eb_system_config` SET `key`='ent_qiniu_uploadUrl' WHERE `id`=14;
UPDATE `eb_system_config` SET `key`='ent_qiniu_storage_region' WHERE `id`=15;


#1.0.2
ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `letter` varchar(10)  NOT NULL DEFAULT '' COMMENT '姓氏首字母' AFTER `name`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `education_image` varchar(256)  NOT NULL DEFAULT '' COMMENT '学历证书' AFTER `education`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `acad_image` varchar(256)  NOT NULL DEFAULT '' COMMENT '学位证书' AFTER `acad`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `work_years` tinyint UNSIGNED NOT NULL DEFAULT 0 COMMENT '工作经验（年）' AFTER `work_start`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `social_num` varchar(32)  NOT NULL DEFAULT '' COMMENT '社保账户' AFTER `email`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `fund_num` varchar(32)  NOT NULL DEFAULT '' COMMENT '公积金账户' AFTER `social_num`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `bank_num` varchar(32)  NOT NULL DEFAULT '' COMMENT '银行卡账户' AFTER `fund_num`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `bank_name` varchar(32)  NOT NULL DEFAULT '' COMMENT '开户行' AFTER `bank_num`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `graduate_name` varchar(32)  NOT NULL DEFAULT '' COMMENT '毕业院校' AFTER `bank_name`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `graduate_date` varchar(32)  NOT NULL DEFAULT '' COMMENT '毕业时间' AFTER `graduate_name`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `interview_date` varchar(32)  NOT NULL DEFAULT '' COMMENT '面试时间' AFTER `graduate_date`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `is_part` tinyint UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否兼职' AFTER `interview_date`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `photo` varchar(256)  NOT NULL DEFAULT '' COMMENT '员工照片' AFTER `is_part`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `card_front` varchar(256)  NOT NULL DEFAULT '' COMMENT '身份证正面' AFTER `photo`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `card_both` varchar(256)  NOT NULL DEFAULT '' COMMENT '身份证背面' AFTER `card_front`;

ALTER TABLE `eb_enterprise_user_card` ADD COLUMN `quit_time` varchar(32)  NULL DEFAULT NULL COMMENT '离职时间' AFTER `treaty_time`;
ALTER TABLE `eb_enterprise_user_card` ADD `interview_position` VARCHAR(64) NOT NULL DEFAULT '' COMMENT '面试职位' AFTER `interview_date`;
ALTER TABLE `eb_enterprise_user_card` DROP INDEX `uid_ent`;

INSERT INTO `eb_system_menus` (`id`, `pid`, `icon`, `menu_name`, `api`, `methods`, `unique_auth`, `menu_path`, `path`, `level`, `other`, `sort`, `entid`, `is_default`, `type`, `is_show`, `status`, `is_del`, `created_at`, `updated_at`) VALUES
(544, 99, '', '在线升级', '', '', 'menus63159a803b9a2', '/setting/enterprise/upgrade', '98/99', 2, '{\"menu_name_en\":\"Online upgrade\"}', 0, 1, 0, 0, 0, 1, NULL, '2022-09-05 06:43:12', '2022-09-05 06:43:12');
INSERT INTO `eb_system_menus` (`id`, `pid`, `icon`, `menu_name`, `api`, `methods`, `unique_auth`, `menu_path`, `path`, `level`, `other`, `sort`, `entid`, `is_default`, `type`, `is_show`, `status`, `is_del`, `created_at`, `updated_at`) VALUES
(546, 88, 'document', '个人简历', '', '', 'menus6315a22fd8511', '/user/resume', '88', 1, '{\"menu_name_en\":\"curriculum vitae\"}', 0, 1, 0, 0, 0, 1, NULL, '2022-09-05 07:16:00', '2022-09-05 07:28:25');
UPDATE `eb_system_role` SET rules='[114,167,188,90,217,218,171,193,91,184,170,223,220,221,173,174,175,179,178,177,219,95,147,148,186,187,117,141,142,180,181,143,144,190,197,196,194,104,105,106,100,101,183,225,224,160,199,200,201,543,544]' WHERE id=1;
UPDATE `eb_system_role` SET rules='[114,167,231,170,546,223,220]' WHERE id=2;
UPDATE `eb_enterprise_user_card` SET status=2,type=4 WHERE status=0;
UPDATE `eb_enterprise_user_card` SET type=1 WHERE status=1;
UPDATE `eb_user_enterprise` SET status=1 WHERE status=0;

CREATE TABLE `eb_enterprise_user_change`  (
    `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增ID',
    `entid` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '企业ID',
    `card_id` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '企业用户名片ID',
    `types` tinyint UNSIGNED NOT NULL DEFAULT 0 COMMENT '变动类型：0、入职；1、转正；2、调岗；3、离职；',
    `date` date NULL DEFAULT NULL COMMENT '变更时间',
    `new_frame` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '新部门ID',
    `old_frame` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '原部门ID',
    `new_position` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '新职位ID',
    `old_position` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '原职位ID',
    `info` varchar(128)  NOT NULL DEFAULT '' COMMENT '原因说明',
    `mark` varchar(500)  NOT NULL DEFAULT '' COMMENT '备注信息',
    `link_id` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联申请单ID',
    `user_id` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '交接人员ID',
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `eb_user_education_history`  (
    `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增id',
    `uid` varchar(32)  NOT NULL DEFAULT '' COMMENT '关联用户ID',
    `resume_id` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联简历ID',
    `start_time` date NULL DEFAULT NULL COMMENT '开始时间',
    `end_time` date NULL DEFAULT NULL COMMENT '结束时间',
    `school_name` varchar(200)  NOT NULL DEFAULT '' COMMENT '学校名称',
    `major` varchar(50)  NOT NULL DEFAULT '' COMMENT '所学专业',
    `education` varchar(50)  NOT NULL DEFAULT '' COMMENT '学历',
    `academic` varchar(50)  NOT NULL DEFAULT '' COMMENT '学位',
    `remark` varchar(255)  NOT NULL DEFAULT '' COMMENT '备注',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `eb_user_education_history_uid_index`(`uid` ASC) USING BTREE,
    INDEX `eb_user_education_history_resume_id_index`(`resume_id` ASC) USING BTREE
) ENGINE = InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `eb_user_resume`  (
    `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增ID',
    `uid` char(36)  NOT NULL,
    `photo` varchar(256)  NOT NULL DEFAULT '' COMMENT '照片',
    `name` varchar(32)  NOT NULL DEFAULT '' COMMENT '员工姓名',
    `phone` varchar(32)  NOT NULL DEFAULT '' COMMENT '手机号',
    `position` varchar(32)  NOT NULL DEFAULT '' COMMENT '期望职位',
    `birthday` varchar(32)  NOT NULL DEFAULT '' COMMENT '生日',
    `nation` varchar(32)  NOT NULL DEFAULT '' COMMENT '种族',
    `politic` varchar(32)  NOT NULL DEFAULT '' COMMENT '政治面貌',
    `native` varchar(32)  NOT NULL DEFAULT '' COMMENT '籍贯',
    `address` varchar(64)  NOT NULL DEFAULT '' COMMENT '居住地',
    `sex` tinyint NOT NULL DEFAULT 0 COMMENT '性别: 0、未知；1、男；2、女；',
    `age` tinyint UNSIGNED NOT NULL DEFAULT 18 COMMENT '年龄',
    `marriage` tinyint UNSIGNED NOT NULL DEFAULT 0 COMMENT '婚姻状况:0、未婚；1、已婚；',
    `is_part` tinyint NOT NULL DEFAULT 0 COMMENT '是否兼职:1、是；0、否；',
    `work_years` tinyint UNSIGNED NOT NULL DEFAULT 0 COMMENT '工作年限',
    `spare_name` varchar(32)  NOT NULL DEFAULT '' COMMENT '紧急联系人',
    `spare_tel` varchar(32)  NOT NULL DEFAULT '' COMMENT '紧急联系电话',
    `email` varchar(64)  NOT NULL DEFAULT '' COMMENT '邮箱',
    `work_time` varchar(32)  NOT NULL DEFAULT '' COMMENT '入职时间',
    `trial_time` varchar(32)  NOT NULL DEFAULT '' COMMENT '试用时间',
    `formal_time` varchar(32)  NOT NULL DEFAULT '' COMMENT '转正时间',
    `treaty_time` varchar(32)  NOT NULL DEFAULT '' COMMENT '合同到期时间',
    `social_num` varchar(32)  NOT NULL DEFAULT '' COMMENT '社保账户',
    `fund_num` varchar(32)  NOT NULL DEFAULT '' COMMENT '公积金账户',
    `bank_num` varchar(32)  NOT NULL DEFAULT '' COMMENT '银行卡账户',
    `bank_name` varchar(32)  NOT NULL DEFAULT '' COMMENT '开户行',
    `graduate_name` varchar(32)  NOT NULL DEFAULT '' COMMENT '毕业院校',
    `graduate_date` varchar(32)  NOT NULL DEFAULT '' COMMENT '毕业时间',
    `card_id` varchar(32)  NOT NULL DEFAULT '' COMMENT '身份证号',
    `card_front` varchar(256)  NOT NULL DEFAULT '' COMMENT '身份证正面',
    `card_both` varchar(256)  NOT NULL DEFAULT '' COMMENT '身份证背面',
    `education` varchar(32)  NOT NULL DEFAULT '' COMMENT '学历',
    `education_image` varchar(256)  NOT NULL DEFAULT '' COMMENT '学历证书',
    `acad` varchar(32)  NOT NULL DEFAULT '' COMMENT '学位',
    `acad_image` varchar(256)  NOT NULL DEFAULT '' COMMENT '学位证书',
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `eb_user_resume_uid_foreign`(`uid` ASC) USING BTREE
) ENGINE = InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `eb_user_token`  (
    `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增ID',
    `uid` varchar(32)  NOT NULL DEFAULT '' COMMENT '关联用户UID',
    `client` varchar(32)  NOT NULL DEFAULT '' COMMENT '登陆客户端名称',
    `last_ip` varchar(32)  NOT NULL DEFAULT '' COMMENT '登陆IP',
    `mac` varchar(32)  NOT NULL DEFAULT '' COMMENT '登陆MAC地址',
    `last_token` varchar(512)  NOT NULL DEFAULT '' COMMENT '上次过期token',
    `remember_token` varchar(512)  NOT NULL DEFAULT '' COMMENT '当前登陆token',
    `fail_time` datetime NULL DEFAULT NULL COMMENT '失效时间',
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `eb_user_work_history`  (
    `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增id',
    `uid` varchar(32)  NOT NULL DEFAULT '' COMMENT '关联用户ID',
    `resume_id` int UNSIGNED NOT NULL DEFAULT 0 COMMENT '关联简历ID',
    `start_time` date NULL DEFAULT NULL COMMENT '开始时间',
    `end_time` date NULL DEFAULT NULL COMMENT '结束时间',
    `company` varchar(200)  NOT NULL DEFAULT '' COMMENT '所在公司',
    `position` varchar(128)  NOT NULL DEFAULT '' COMMENT '职位',
    `describe` varchar(500)  NOT NULL DEFAULT '' COMMENT '工作描述',
    `quit_reason` varchar(500)  NOT NULL DEFAULT '' COMMENT '离职原因',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `eb_user_work_history_uid_index`(`uid` ASC) USING BTREE,
    INDEX `eb_user_work_history_resume_id_index`(`resume_id` ASC) USING BTREE
) ENGINE = InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `eb_user_card_perfect` (
    `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增ID',
    `entid` int UNSIGNED NOT NULL DEFAULT '0' COMMENT '企业ID',
    `uid` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '关联用户UID',
    `card_id` int UNSIGNED NOT NULL DEFAULT '0' COMMENT '关联企业用户名片ID',
    `uniqued` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '唯一值',
    `total` int NOT NULL DEFAULT '0' COMMENT '可操作量：-1、不限',
    `used` int UNSIGNED NOT NULL DEFAULT '0' COMMENT '已使用量',
    `status` tinyint UNSIGNED NOT NULL DEFAULT '0' COMMENT '状态：0、待处理；1、已通过；2、已拒绝；',
    `fail_time` datetime DEFAULT NULL COMMENT '失效时间',
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `eb_enterprise_user_salary` (
    `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增ID',
    `entid` int UNSIGNED NOT NULL DEFAULT '0' COMMENT '企业ID',
    `card_id` int UNSIGNED NOT NULL DEFAULT '0' COMMENT '企业用户名片ID',
    `total` decimal(11,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '变更内容',
    `take_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '生效时间',
    `content` varchar(2000) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '变更内容',
    `mark` varchar(300) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '变更原因',
    `link_id` int UNSIGNED NOT NULL DEFAULT '0' COMMENT '关联申请单ID',
    `created_at` timestamp NULL DEFAULT NULL,
    `updated_at` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
