<?php

namespace App\Jobs\Attend;

use App\Constants\NoticeEnum;
use App\Http\Service\Attendance\AttendanceRemindService;
use App\Http\Service\Company\CompanyService;
use App\Http\Service\Message\MessageService;
use Hhxsv5\LaravelS\Swoole\Timer\CronJob;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;

/**
 * 考勤日报
 */
class AttendanceTeamDailyJob extends CronJob
{

    /**
     * 频率：每1m运行一次
     */
    public function interval(): int
    {
        return 60000;
    }

    public function run(): void
    {
        $msgService    = app()->get(MessageService::class);
        $remindService = app()->get(AttendanceRemindService::class);
        $tz            = config('app.timezone');
        try {
            $entIds = app()->get(CompanyService::class)->column(['status' => 1], 'id');
            foreach ($entIds as $entId) {
                $dailyMessage = $msgService->getMessageContent($entId, NoticeEnum::TEAM_ATTENDANCE_DAILY_REMIND);
                if ($dailyMessage && now()->format('H:i') === $dailyMessage['remind_time']) {
                    $remindService->setEntValue($entId)->sendTeamDailyPush(Carbon::now($tz)->subDays()->toDateTimeString());
                }
            }
        } catch (\Throwable $e) {
            Log::error('团队日报推送失败：' . $e->getMessage(), ['file' => $e->getFile(), 'line' => $e->getLine()]);
        }
    }

}
