import { Object as obj } from 'ol';
import { ProjectionLike } from 'ol/proj';
import Event from 'ol/events/Event';
import { bindAll, removeNode } from './utils';
import formatGeoJSON from './utils/formatGeoJSON';
declare type Nullable<T> = T | null;
declare type NoDef<T> = T | undefined;
interface OptionsTypes {
    source?: ProjectionLike;
    destination?: ProjectionLike;
    forcedRerender?: boolean;
    forcedPrecomposeRerender?: boolean;
    hideOnZooming?: boolean;
    hideOnMoving?: boolean;
    hideOnRotating?: boolean;
    convertTypes?: string[] | number[];
    insertFirst?: boolean;
    stopEvent?: boolean;
    polyfillEvents?: boolean;
    [key: string]: any;
}
declare class EChartsLayer extends obj {
    static formatGeoJSON: typeof formatGeoJSON;
    static bind: (func: Function, context: any, ...args: any[]) => Function;
    static merge: (a: any, b: any) => any;
    static uuid: () => string;
    static bindAll: typeof bindAll;
    static arrayAdd: (array: any[], item: any) => any[];
    static removeNode: typeof removeNode;
    static isObject: (value: any) => boolean;
    private _chartOptions;
    private _isRegistered;
    private _incremental;
    private _coordinateSystem;
    private coordinateSystemId;
    private readonly _options;
    private _initEvent;
    private prevVisibleState;
    $chart: Nullable<any>;
    $container: NoDef<HTMLElement>;
    _map: any;
    constructor(chartOptions?: NoDef<Nullable<object>>, options?: NoDef<Nullable<OptionsTypes>>, map?: any);
    appendTo(map: any, forceIgnore?: boolean): void;
    getMap(): any;
    setMap(map: any, forceIgnore?: boolean): void;
    getChartOptions(): object | undefined | null;
    setChartOptions(options?: object): this;
    appendData(data: any, save?: boolean | undefined | null): this;
    clear(keep?: boolean): void;
    remove(): void;
    show(): void;
    private innerShow;
    hide(): void;
    private innerHide;
    isVisible(): boolean | undefined;
    showLoading(): void;
    hideLoading(): void;
    setZIndex(zIndex: string | number | null): void;
    getZIndex(): string | null | undefined;
    setVisible(visible: boolean): void;
    render(): void;
    redraw(): void;
    updateViewSize(size: number[]): void;
    private onResize;
    private onZoomEnd;
    private onDragRotateEnd;
    private onMoveStart;
    private onMoveEnd;
    private onClick;
    private mouseDown;
    private mouseUp;
    private mouseMove;
    private onCenterChange;
    private handleMapChanged;
    private createLayerContainer;
    private bindEvent;
    private unBindEvent;
    private clearAndRedraw;
    private registerMap;
    private convertData;
    private getCoordinateSystem;
    dispatchEvent(event: object | Event | string): boolean | undefined;
    set(key: string, value: any, optSilent?: boolean): void;
    get(key: string): any;
    unset(key: string, optSilent?: boolean): void;
    on(type: any, listener: (p0: any) => void): import("ol/events").EventsKey;
    un(type: any, listener: (p0: any) => void): void;
}
export default EChartsLayer;
