import { Object as Object$1 } from 'ol';
import { ProjectionLike } from 'ol/proj';

/**
 * @module ol/events/Event
 */
/**
 * @classdesc
 * Stripped down implementation of the W3C DOM Level 2 Event interface.
 * See https://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-interface.
 *
 * This implementation only provides `type` and `target` properties, and
 * `stopPropagation` and `preventDefault` methods. It is meant as base class
 * for higher level events defined in the library, and works with
 * {@link module:ol/events/Target~Target}.
 */
declare class BaseEvent {
    /**
     * @param {string} type Type.
     */
    constructor(type: string);
    /**
     * @type {boolean}
     */
    propagationStopped: boolean;
    /**
     * @type {boolean}
     */
    defaultPrevented: boolean;
    /**
     * The event type.
     * @type {string}
     * @api
     */
    type: string;
    /**
     * The event target.
     * @type {Object}
     * @api
     */
    target: any;
    /**
     * Prevent default. This means that no emulated `click`, `singleclick` or `doubleclick` events
     * will be fired.
     * @api
     */
    preventDefault(): void;
    /**
     * Stop event propagation.
     * @api
     */
    stopPropagation(): void;
}

/**
 * bind function array
 * @param fns
 * @param context
 */
declare function bindAll(fns: string[] | number[], context: any): void;
/**
 * remove node
 * @param node
 */
declare function removeNode(node: HTMLElement): HTMLElement | null;

/**
 * decode geoJson
 * @param json
 */
declare function export_default(json: any): {
    type: string;
    crs: {};
    features: any;
};

type Nullable<T> = T | null;
type NoDef<T> = T | undefined;
interface OptionsTypes {
    source?: ProjectionLike;
    destination?: ProjectionLike;
    forcedRerender?: boolean;
    forcedPrecomposeRerender?: boolean;
    hideOnZooming?: boolean;
    hideOnMoving?: boolean;
    hideOnRotating?: boolean;
    convertTypes?: string[] | number[];
    insertFirst?: boolean;
    stopEvent?: boolean;
    polyfillEvents?: boolean;
    [key: string]: any;
}
declare class EChartsLayer extends Object$1 {
    static formatGeoJSON: typeof export_default;
    static bind: (func: Function, context: any, ...args: any[]) => Function;
    static merge: (a: any, b: any) => any;
    static uuid: () => string;
    static bindAll: typeof bindAll;
    static arrayAdd: (array: any[], item: any) => any[];
    static removeNode: typeof removeNode;
    static isObject: (value: any) => boolean;
    private _chartOptions;
    private _isRegistered;
    private _incremental;
    private _coordinateSystem;
    private coordinateSystemId;
    private readonly _options;
    private _initEvent;
    private prevVisibleState;
    $chart: Nullable<any>;
    $container: NoDef<HTMLElement>;
    _map: any;
    constructor(chartOptions?: NoDef<Nullable<object>>, options?: NoDef<Nullable<OptionsTypes>>, map?: any);
    /**
     * append layer to map
     * @param map
     * @param forceIgnore
     */
    appendTo(map: any, forceIgnore?: boolean): void;
    /**
     * get ol map
     * @returns {ol.Map}
     */
    getMap(): any;
    /**
     * set map
     * @param map
     * @param forceIgnore 是否忽略instanceof检查
     */
    setMap(map: any, forceIgnore?: boolean): void;
    /**
     * get echarts options
     */
    getChartOptions(): object | undefined | null;
    /**
     * set echarts options and redraw
     * @param options
     * @returns {EChartsLayer}
     */
    setChartOptions(options?: object): this;
    /**
     * append data
     * @param data
     * @param save
     * @returns {EChartsLayer}
     */
    appendData(data: any, save?: boolean | undefined | null): this;
    /**
     * clear layer
     */
    clear(keep?: boolean): void;
    /**
     * remove layer
     */
    remove(): void;
    /**
     * show layer
     */
    show(): void;
    private innerShow;
    /**
     * hide layer
     */
    hide(): void;
    private innerHide;
    /**
     * check layer is visible
     */
    isVisible(): boolean | undefined;
    /**
     * show loading bar
     */
    showLoading(): void;
    /**
     * hide loading bar
     */
    hideLoading(): void;
    /**
     * set zindex
     * @param zIndex
     */
    setZIndex(zIndex: string | number): void;
    /**
     * get zindex
     */
    getZIndex(): string | undefined;
    /**
     * set visible
     * from: https://github.com/sakitam-fdd/ol3Echarts/blob/3929ad72f562661ba3511d4d9e360dee5ac793c2/
     * packages/ol-echarts/src/index.js
     * author: https://github.com/ChenGuanglin0924
     * @param visible
     */
    setVisible(visible: boolean): void;
    /**
     * render
     */
    render(): void;
    /**
     * redraw echarts layer
     */
    redraw(): void;
    /**
     * update container size
     * @param size
     */
    updateViewSize(size: number[]): void;
    /**
     * handle map view resize
     */
    private onResize;
    /**
     * handle zoom end events
     */
    private onZoomEnd;
    /**
     * handle rotate end events
     */
    private onDragRotateEnd;
    /**
     * handle move start events
     */
    private onMoveStart;
    /**
     * handle move end events
     */
    private onMoveEnd;
    /**
     * on mouse click
     * @param event
     */
    private onClick;
    /**
     * on mouse down
     * @param event
     */
    private mouseDown;
    /**
     * mouse up
     * @param event
     */
    private mouseUp;
    /**
     * mousemove 事件需要分两种情况处理:
     * 1. ol-overlaycontainer-stopevent 有高度, 则 propagation path 是 ol-viewport -> ol-overlaycontainer-stopevent.
     * 此时 ol-overlaycontainer 无法获得事件, 只能 mock 处理
     * 2. ol-overlaycontainer-stopevent 没有高度, 则 propagation path 是 ol-viewport -> ol-overlaycontainer. 无需 mock
     * @param event
     */
    private mouseMove;
    /**
     * handle center change
     */
    private onCenterChange;
    /**
     * handle map change
     */
    private handleMapChanged;
    /**
     * create container
     */
    private createLayerContainer;
    /**
     * register events
     * @private
     */
    private bindEvent;
    /**
     * un register events
     * @private
     */
    private unBindEvent;
    /**
     * clear chart and redraw
     * @private
     */
    private clearAndRedraw;
    /**
     * register map coordinate system
     * @private
     */
    private registerMap;
    /**
     * 重新处理数据
     * @param options
     * @returns {*}
     */
    private convertData;
    /**
     * register coordinateSystem
     * @param options
     */
    private getCoordinateSystem;
    /**
     * dispatch event
     * @param event
     */
    dispatchEvent(event: object | BaseEvent | string): boolean | undefined;
    set(key: string, value: any, optSilent?: boolean): void;
    get(key: string): any;
}

export { EChartsLayer as default };
