package com.bcxin.sync.apis.responses;
import lombok.Getter;

@Getter
public class SyncViaFtpDataImportResponse {
    private final String api="/v2/sync/ftp/data-import";// 接口名称
    private final String v="1.1";// 版本号
    private final String retType;// 状态码
    private final Object data;// 返回数据对象
    private final String msg;// 返回信息

    public SyncViaFtpDataImportResponse(boolean isSuccess, Object data, String msg) {
        this.data = data;
        this.msg = msg;

        if (isSuccess) {
            this.retType = "0";
        } else {
            this.retType = "1";
        }
    }

    public static SyncViaFtpDataImportResponse create(boolean isSuccess, Object data, String msg) {
        return new SyncViaFtpDataImportResponse(isSuccess, data, msg);
    }
}
